//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//======================================================== FX_CONST
DMR_CLR1A	EQU	#46
DMR_CLR1B	EQU	#46
DMR_CLR2A	EQU	#44
DMR_CLR2B	EQU	#44	
DMR_CLR3A	EQU	#05
DMR_CLR3B	EQU	#05

FADE_CALL_DELAY	EQU	0
FADE_STEP_DELAY EQU	5
//======================================================== FX_INIT
EFF_INI_
	EI
	HALT
	;---
	LD	A,#17
	CALL	PAGER
	;---
	LD	HL,#C000
	LD	DE,#C001
	LD	BC,6144
	LD	(HL),L
	LDIR
	LD	BC,767
	LD	(HL),#47
	LDIR
	LD	HL,#4000
	LD	DE,#4001
	LD	BC,6911
	LD	(HL),L
	LDIR
	;---
	LD	HL,DMR_LOGO
	LD	DE,#C842 + 5*256
	LD	LX,27
INI1	;--
	LD	A,E
	;--
	DUP	28
	LDI
	EDUP
	;--
	LD	E,A
	INC	D
	LD	A,D
	AND	7
	JP	NZ,INI2
	LD	A,D
	SUB	8
	LD	D,A
	LD	A,E
	ADD	A,#20
	LD	E,A
	;--
INI2	DEC	LX
	JP	NZ,INI1
	;--
	CALL	INIT_RANDOM


	RET
//======================================================== FX_MAINLOOP
EFF_RUN_
	EI
	HALT
	
	;---
	IF SHOW_FRAMES = 1
	  LD A,1: OUT (#FE),A
	ELSE
	
	LD	A,2
	DEC	A
	JP	NZ,$-1
	
	ENDIF
	;---
	NOP:NOP
	LD	A,#17
	CALL	PAGER
	
	EXX
	LD	BC,#7FFD
	LD	HL,PAGETBL
	EXX
	;---
	LD	HL,#0000
RND_ADR	EQU	$-2
	LD	DE,#4000
	LD	A,4
RND1	;--
	DUP	256
	LDI	;
	EDUP
	;--
	INC	D
	DEC	A
	JP	NZ,RND1
	;------
	LD	A,4
RND2	;--
	DUP	256
	LDI	;
	EDUP
	;--
	INC	D
	DEC	A
	JP	NZ,RND2
	;----
	LD	A,9+16
	DEC	A
	JP	NZ,$-1
	
	IF SHOW_FRAMES = 1
	  LD A,3: OUT (#FE),A	
	ENDIF
	;----
	LD	LX,32
RND3	;--	
	EXX	;4
	LD	A,(HL)	;7
	INC	L	;4
	OUT	(C),A	;12 /23
	EXX	;4
	;-
	DUP	8
	LDI	;16 *8=128
	EDUP
	;- w54
	LD BC,0:LD BC,0:LD BC,0:LD BC,0:LD B,0
	;-
	DEC	LX	;8
	JP	NZ,RND3 ;10
	;--
	INC	D
	LD	LX,9
RND4	;--	
	EXX	;4
	LD	A,(HL)	;7
	INC	L	;4
	OUT	(C),A	;12 /23
	EXX	;4
	;-
	DUP	8
	LDI	;16 *8=128
	EDUP
	;- w54
	LD BC,0:LD BC,0:LD BC,0:LD BC,0:LD B,0
	;-
	DEC	LX	;8
	JP	NZ,RND4 ;10
	;--
	IF SHOW_FRAMES = 1
	  LD A,1: OUT (#FE),A	
	ENDIF
	;--
	DUP	64+64+64-8
	LDI
	EDUP
	;--
	INC	D
	;--
	LD	A,2
RND5	;--
	DUP	256
	LDI	;
	EDUP
	;--
	INC	D
	DEC	A
	JP	NZ,RND5
	;--
	IF SHOW_FRAMES = 1
	  LD A,3: OUT (#FE),A	
	ENDIF
	;--- line 1
	LD	DE,#C820 + 256*6
	DUP	13
	LDI
	EDUP
	LD	A,(HL)
	AND	%00000111
	LD	(DE),A
	;INC	HL
	INC	E
	DUP	18
	LDI
	EDUP
	;--- line 2
	LD	DE,#C840
	LDI:LDI
	LD	A,(HL)
	AND	%11000000
	LD	(DE),A
	;INC	HL
	INC	E
	INC	E
	INC	E
	DUP	7
	LDI
	EDUP
	LD	A,(HL)
	AND	%11111100
	LD	(DE),A
	INC	E
	LD	A,(HL)
	AND	%00000001
	LD	(DE),A
	INC	E
	DUP	8
	LDI
	EDUP
	LD	A,(HL)
	AND	%11111100
	LD	(DE),A
	;INC	HL
	INC	E
	INC	E
	INC	E
	DUP	7
	LDI
	EDUP
	;--- line 3
	LD	DE,#CA40
	LDI:LDI
	LD	A,(HL)
	AND	%11110000
	LD	(DE),A
	INC E:INC E:INC E
	LD	A,(HL)
	AND	%00111111
	LD	(DE),A
	INC	E
	DUP	6
	LDI
	EDUP
	LD	A,(HL)
	AND	%11110000
	LD	(DE),A
	INC E:INC E
	LD	A,(HL)
	AND	%01111111
	LD	(DE),A
	INC	E
	DUP	7
	LDI
	EDUP
	LD	A,(HL)
	AND	%11111100
	LD	(DE),A
	INC E:INC E:INC E
	DUP	7
	LDI
	EDUP
	;--- line 4
	LD	DE,#CC40
	LDI:LDI
	LD	A,(HL)
	AND	%11111100
	LD	(DE),A
	LD	E,#56
	LD	A,(HL)
	AND	%01111100
	LD	(DE),A
	LD	E,#5F
	LD	A,(HL)
	AND	%00000111
	LD	(DE),A
	;--- line 5
	LD	DE,#CE40
	LDI:LDI:LDI
	LD	E,#56
	LD	A,(HL)
	AND	%00011100
	LD	(DE),A
	LD	E,#5F
	LD	A,(HL)
	AND	%00011111
	LD	(DE),A
	;--- line 6
	LD	DE,#C860
	LDI:LDI:LDI
	LD	A,(HL)
	AND	%11000000
	LD	(DE),A
	LD	E,#76
	LD	A,(HL)
	AND	%00000100
	LD	(DE),A
	LD	E,#7F
	LD	A,(HL)
	AND	%01111111
	LD	(DE),A
	;--- line 7
	LD	DE,#CA60
	LDI:LDI:LDI
	LD	A,(HL)
	AND	%11110000
	LD	(DE),A
	LD	E,#7E
	LD	A,(HL)
	AND	%00000001
	LD	(DE),A
	INC	E
	LDI
	;--- line 8
	LD	DE,#CC60
	LDI:LDI:LDI
	LD	A,(HL)
	AND	%11110000
	LD	(DE),A
	LD	E,#7E
	LD	A,(HL)
	AND	%00000111
	LD	(DE),A
	INC	E
	LDI
	;--- line 9
	LD	DE,#CE60
	LDI:LDI:LDI
	LD	A,(HL)
	AND	%11000000
	LD	(DE),A
	LD	E,#7E
	LD	A,(HL)
	AND	%00011111
	LD	(DE),A
	INC	E
	LDI
	;--- line 10
	LD	DE,#C880
	LDI:LDI:LDI
	LD	E,#9E
	LD	A,(HL)
	AND	%01111111
	LD	(DE),A
	INC	E
	LDI
	;--- line 11
	LD	DE,#CA80
	LDI:LDI
	LD	A,(HL)
	AND	%11111100
	LD	(DE),A
	LD	E,#9D
	LD	A,(HL)
	AND	%00000001
	LD	(DE),A
	INC	E
	LDI
	LDI
	;--- line 12
	LD	DE,#CC80
	LDI:LDI
	LD	A,(HL)
	AND	%11110000
	LD	(DE),A
	LD	E,#9D
	LD	A,(HL)
	AND	%00000111
	LD	(DE),A
	INC	E
	LDI
	LDI
	;--- line 13
	LD	DE,#CE80
	LDI:LDI
	LD	A,(HL)
	AND	%11000000
	LD	(DE),A
	LD	E,#9D
	LD	A,(HL)
	AND	%00011111
	LD	(DE),A
	INC	E
	LDI
	LDI
	;--- line 14
	LD	DE,#C8A0
	LDI:LDI
	LD	E,#BD
	LD	A,(HL)
	AND	%01111111
	LD	(DE),A
	INC	E
	LDI
	LDI
	;--- line 15
	LD	DE,#CAA0
	LDI
	LD	A,(HL)
	AND	%11111100
	LD	(DE),A
	LD	E,#BD
	LD	A,(HL)
	AND	%01111111
	LD	(DE),A
	INC	E
	LDI
	LDI
	;--- line 16 --- MMM
	LD	DE,#CCA0
	LDI
	LD	A,(HL)
	AND	%11110000
	LD	(DE),A
	LD	E,#BD
	LD	A,(HL)
	AND	%00011111
	LD	(DE),A
	INC	E
	LDI
	LDI
	;--- line 17
	LD	DE,#CEA0
	LDI
	LD	A,(HL)
	AND	%11000000
	LD	(DE),A
	LD	E,#AA
	LD	A,(HL)
	AND	%00001111
	LD	(DE),A
	INC	E
	LD	A,(HL)
	AND	%11111000
	LD	(DE),A	
	LD	E,#BD
	LD	A,(HL)
	AND	%00000111
	LD	(DE),A
	INC	E
	LDI
	LDI
	;--- line 18
	LD	DE,#C8C0
	LDI
	LD	E,#CA
	LD	A,(HL)
	AND	%00111111
	LD	(DE),A
	INC	E
	LD	A,(HL)
	AND	%11100000
	LD	(DE),A	
	LD	E,#DD
	LD	A,(HL)
	AND	%00000001
	LD	(DE),A
	INC	E
	LDI
	LDI
	;--- line 19
	LD	DE,#CAC0
	DUP	7
	LDI
	EDUP
	LD	A,(HL)
	AND	%11111100
	LD	(DE),A
	INC E:INC E:INC E
	LD	A,(HL)
	AND	%00001111
	LD	(DE),A	
	INC	E
	DUP	15
	LDI
	EDUP
	LD	A,(HL)
	AND	%11111100
	LD	(DE),A
	LD	E,#DE
	LD	A,(HL)
	AND	%01111111
	LD	(DE),A
	INC	E
	LDI
	;--- line 20
	LD	DE,#CCC0
	DUP	8
	LDI
	EDUP
	INC E:INC E
	LD	A,(HL)
	AND	%00000011
	LD	(DE),A	
	INC	E
	DUP	16
	LDI
	EDUP
	LD	E,#DE
	LD	A,(HL)
	AND	%00011111
	LD	(DE),A
	INC	E
	LDI
	;---
	IF SHOW_FRAMES = 1
	  LD A,1: OUT (#FE),A	
	ENDIF
	;---

	CALL	GIGAATTR
	

	;---
	IF SHOW_FRAMES = 1
	  LD A,3: OUT (#FE),A	
	ENDIF
	;---
	CALL	NOISEFADEIN
	
	
	LD	A,0
CLRW	EQU	$-1
	INC	A
	AND	7
	LD	(CLRW),A
	JR	NZ,CL1
	;--
	LD	A,255
CLR	EQU	$-1
	CP	8
	JP	Z,CL1
	INC	A
	LD	(CLR),A
	OR	#40
	LD	(COLOR1),A
	LD	(COLOR1+1),A
	
CL1	;--

	IF SHOW_FRAMES = 1
	  LD A,1: OUT (#FE),A
	ENDIF

	CALL	FADEIN
	;CALL	TRIFADE
	
SS3	LD	A,0
	INC	A
	AND	3
	LD	(SS3+1),A
	JR	NZ,SS4

	LD	A,(RND_ADR)
	LD	B,A
	LD	A,(RND_ADR + 1)
	ADD	A,3
	ADD	A,B
	AND	#1F
	OR	1
	LD	(RND_ADR + 1),A
	LD	A,(RND_ADR)
	ADD	A,17
	LD	(RND_ADR),A
SS4
	IF SHOW_FRAMES = 1
	  XOR A: OUT (#FE),A
	ENDIF

	RET

//======================================================== FX_PROCEDURES
GIGAATTR
	LD	A,(FADE_B)
	CP	41
	RET	Z

	LD	A,0
GIGA	EQU	$-1
	XOR	#FF
	LD	(GIGA),A
	LD	A,DMR_CLR3A
	LD	BC,DMR_CLR2A * 256 + DMR_CLR1A
	JR	Z,GIGA1
	LD	A,DMR_CLR3B
	LD	BC,DMR_CLR2B * 256 + DMR_CLR1B
GIGA1
	LD	HL,#D9A2
	DUP	8
	LD	(HL),A
	INC	L
	EDUP
	INC	L
	INC	L
	DUP	17
	LD	(HL),A
	INC	L
	EDUP	
	;-
	LD	HL,#D983
	DUP	26
	LD	(HL),B
	INC	L
	EDUP
	;-
	LD	HL,#D964
	DUP	26
	LD	(HL),C
	INC	L
	EDUP
	RET



; задача получить от 1 до 40 гарантированно разных случайных чисел в диспазоне 0..39
INIT_RANDOM
	LD	HL,RAND_TBL
INIR1	CALL	GET_RANDOM40
	LD	C,L
	CALL	INIR_CHECK
	LD	L,C
	JR	Z,INIR1
	LD	(HL),A
	INC	L
	JP	NZ,INIR1
	RET
;---------
INIR_CHECK
	LD	B,39
INIR_CHECK_1
	DEC	L
	CP	(HL)
	RET	Z
	DJNZ	INIR_CHECK_1
	INC	B
	RET
;---------
GET_RANDOM40
	CALL	GET_RANDOM
GETR40L	CP	40
	RET	C
	SUB	40
	JR	GETR40L
;---------
GET_RANDOM
	LD  A,137
SEED	EQU	$-1
	LD	B,A
	ADD	A,A
	XOR	B
	LD	B,A
	SRL	A
	XOR	B
	LD	B,A
	ADD	A,A
	ADD	A,A
	XOR	B
	LD	(SEED),A
	RET
;---------
FADEIN
	LD	A,(FADE_B)
	CP	41
	RET	Z
	;---------- fade call delay
	LD	A,0
FADE_W	EQU	$-1
	INC	A
	AND	FADE_CALL_DELAY
	LD	(FADE_W),A
	RET	NZ
	;---
	LD	HL,PAGETBL
	LD	A,#17
	DUP	40
	LD	(HL),A
	INC	L
	EDUP
	;---
	LD	A,(COLOR1)
	CP	#48
	RET	NZ
	;----------
	;LD	A,0
FADE_R	;EQU	$-1
	;ADD	A,17
	;LD	(FADE_R),A
	CALL	GET_RANDOM
	AND	127
	;--
	LD	L,A
	LD	H,RAND_TBL / 256
	LD	D,PAGETBL / 256
	;--
	LD	A,#17+8
	LD	B,1
FADE_B	EQU	$-1
FADEIN1	LD	E,(HL)
	INC	L
	LD	(DE),A
	DJNZ	FADEIN1
	;---
	LD	A,0
FADE_A	EQU	$-1
	INC	A
	LD	(FADE_A),A
	CP	FADE_STEP_DELAY
	RET	NZ
	XOR	A
	LD	(FADE_A),A
	;---
	LD	A,(FADE_B)
	INC	A
	LD	(FADE_B),A
	RET

//======================================================== FX_DATA
NOISEFADEIN
	LD	A,(COLOR1)
	CP	#48
	RET	Z
	;--
	LD	(SOHRSP),SP
	LD	SP,#5B00
	LD	HL,#0000
COLOR1	EQU	$-2
	LD	A,12
ATTR1	;--
	DUP	32
	PUSH	HL
	EDUP
	DEC	A
	JP	NZ,ATTR1
	;--
	LD	SP,0
SOHRSP	EQU	$-2
	RET

;-------------------------------------
TRIFADE
	LD	A,(FADE_B)
	CP	41
	RET	NZ
	;---
	LD	A,32
TRIFADE_W2 EQU $-1
	SUB	1
	ADC	A,0
	LD	(TRIFADE_W2),A
	RET	NZ
	
	LD	HL,#C890
	LD	(HL),0
	LD	HL,#C990
	LD	(HL),#80
	LD	HL,#C8B1
	LD	(HL),0
	LD	HL,#C9B1
	LD	(HL),#80
	LD	HL,#C96F
	LD	(HL),#80
	LD	HL,#CB6E
	LD	(HL),#03
	LD	HL,#CC6E
	LD	(HL),#07
	LD	HL,#CD6E
	LD	(HL),#0F
	;---
	LD	A,0
TRIFADE_W EQU $-1
	INC	A
	AND	1
	LD	(TRIFADE_W),A
	;RET	NZ
	;---
	LD	(SOHRSPTRIF),SP
	LD	HL,TRIF_TBL
TRIF_TBL_ADR	EQU	$-2
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	LD	A,D
	OR	E
	RET	Z
	;-
	EX	DE,HL
	LD	SP,HL
	EX	DE,HL
	;-
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	LD	(TRIF_TBL_ADR),HL
	EX	DE,HL
	XOR	A
	JP	(HL)

	INCLUDE "dmr_triangle_fade_tbl.asm"

	ALIGN 256
DMR_LOGO INCLUDE "bin/dmr_logo.asm"
;-----------
	ALIGN 256
PAGETBL
	DS	256, #17
	DS	256,0
;-----------
	ALIGN 256
RAND_TBL
	DS	256,0
	DS	256,0


	DISPLAY '-------------------------------- FX VARS: '
	DISPLAY 'RAND_TBL ', /A, RAND_TBL
	DISPLAY 'PAGETBL ', /A, PAGETBL
	DISPLAY 'FADEIN ', /A, FADEIN
	DISPLAY 'TRIFADE ', /A, TRIFADE
