//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//======================================================== FX_CONST
BUFF	EQU	#9D00
MDX0	EQU	0
MDY0	EQU	0
ROT0	EQU	#1100

ROT_STEP	EQU	#0200
MOV_X_STEP	EQU	#0300
MOV_Y_STEP	EQU	#0240

//======================================================== FX_INIT
EFF_INI_
	EI
	HALT
	LD	A,#17
	CALL	PAGER
	;--
	CALL	MRTCLR
	CALL	NEXT
	;--
	LD	HL,#4000
	LD	E,L
	
	LD	LX,2
INI3	LD	C,24
INI2	LD	B,4
INI1	PUSH	HL
	DUP	32
	LD	(HL),E
	INC	L
	EDUP
	POP	HL
	CALL	DOWNHL
	DJNZ	INI1
	LD	A,E
	XOR	#FF
	LD	E,A
	DEC	C
	JP	NZ,INI2
	;--
	LD	A,E
	XOR	#FF
	LD	E,A
	DEC	LX
	JP	NZ,INI3
	
	
	
	
	;--
	LD	HL,#4000
	LD	DE,#C000
	LD	BC,6912
	LDIR
	;----
	EI
	HALT
	LD	HL,FX_SWAP_PG
	LD	(IM2CALL),HL
	;---
	RET
	;---
DOWNHL	INC	H
	LD	A,H
	AND	7
	RET	NZ
	LD	A,L
	ADD	A,#20
	LD	L,A
	RET	C
	LD	A,H
	SUB	8
	LD	H,A
	RET
;---------------------------------
FX_SWAP_PG
	LD	A,(PAGE)
	XOR	#08
	LD	(PAGE),A
	RET
//======================================================== FX_MAINLOOP

EFF_RUN_
		IF SHOW_FRAMES=1
		LD	A,(FRAMES_QTY)
		PUSH	AF
		XOR	A
		LD	(FRAMES_QTY),A
		ENDIF
	EI
	HALT
		IF SHOW_FRAMES=1
		POP AF:OUT (#FE),A
		ENDIF
	CALL	MRT
	CALL	MRTOUT
	CALL	MRTCLR
	CALL	NEXT
		IF SHOW_FRAMES=1
		XOR A:OUT (#FE),A
		ENDIF
	RET
//======================================================== FX_PROCEDURES
NEXT	
	LD	HL,ROT0
ROTHL	EQU	$-2
	LD	BC,ROT_STEP
	ADD	HL,BC
	LD	(ROTHL),HL
	LD	L,H
	LD	H,TBL_ROT / 256
	LD	A,(HL)
	LD	(ROTA),A
	;---
	LD	HL,0
MOV_X	EQU	$-2
	LD	BC,MOV_X_STEP
	ADD	HL,BC
	LD	(MOV_X),HL
	LD	L,H
	LD	H,TBL_MOV_X / 256
	LD	A,(HL)
	LD	(MDX_1 + 1),A
	LD	(MDX_2 + 1),A
	LD	(MDX_3 + 1),A
	;---
	LD	HL,0
MOV_Y	EQU	$-2
	LD	BC,MOV_Y_STEP
	ADD	HL,BC
	LD	(MOV_Y),HL
	LD	L,H
	LD	H,TBL_MOV_Y / 256
	LD	A,(HL)
	LD	(MDY_1 + 1),A
	LD	(MDY_2 + 1),A
	LD	(MDY_3 + 1),A
	;---
	RET
;--------------------------------------
MRTOUT
	LD	A,(PAGE)
	OR	#07
	CALL	PAGER
	;---
	LD	B,PAL_A / 256
	LD	DE,#59A0
	CALL	MRTOUT0
	LD	HL,#5AE0
	LD	DE,#5800
	CALL	MRTMV
	
	
	LD	B,PAL_B / 256
	LD	DE,#D9A0
	CALL	MRTOUT0
	LD	HL,#DAE0
	LD	DE,#D800

MRTMV	LD	A,12
MO1	DUP	32
	LDI
	EDUP
	LD	BC,0-64
	ADD	HL,BC
	DEC	A
	JP	NZ,MO1
	RET
	;----
MRTOUT0	LD	LX,11
	LD	L,low BUFF
	PUSH	DE
MRTOUT1	;---
	LD	H,BUFF / 256
	;-
	DUP	31
	LD	C,(HL)	;7
	LD	A,(BC)	;7
	LD	(DE),A	;7
	INC	E	;4
	INC	H	;4
	EDUP
	;-
	LD	C,(HL)	;7
	LD	A,(BC)	;7
	LD	(DE),A	;7
	INC	DE	;6
	INC	L	;4
	INC	L	;4
	;--
	DEC	LX	   ;8
	JP	NZ,MRTOUT1 ;10
	;----------------------
	POP	HL
	LD	LX,11
	LD	E,low BUFF + 1
	INC	B
MRTOUT3 ;---
	LD	D,BUFF / 256
	;-
	DUP	31
	LD	A,(DE)	;7
	LD	C,A	;4
	LD	A,(BC)	;7
	OR	(HL)	;7
	LD	(HL),A	;7
	INC	L	;4
	INC	D	;4
	EDUP
	;-
	LD	A,(DE)	;7
	LD	C,A	;4
	LD	A,(BC)	;7
	OR	(HL)	;7
	LD	(HL),A	;7
	INC	HL	;4
	INC	E	;4
	INC	E	;4
	;--
	DEC	LX	   ;8
	JP	NZ,MRTOUT3 ;10
	
	
	RET
;-------------------------------------------
MRTCLR
	LD	(MRTCLR_SOHR_SP),SP
	;---
	LD	B,32
	LD	DE,0
	LD	HL,BUFF+26
MRTCLR1	LD	SP,HL
	DUP	13
	PUSH	DE
	EDUP
	INC	H
	DJNZ	MRTCLR1
	;---
	LD	SP,0
MRTCLR_SOHR_SP EQU $-2
	RET
;-------------------------------------------
;tx = x*cos(a)-y*sin(a);
;ty = x*sin(a)+y*cos(a);
YYY	EQU	6 + low BUFF - 1

MRT	
	LD	A,(PAGE)
	AND	#18
	CALL	PAGER
	;---
	LD	IY,TBL_YYY
	;---
	LD	A,0
ROTA	EQU	$-1
	OR	#C0
	LD	(ROTH+1),A
	LD	(COS1_1+1),A
	LD	(COS2_1+1),A
	LD	(COS1_2+1),A
	LD	(COS2_2+1),A
	LD	(COS1_3+1),A
	LD	(COS2_3+1),A
	;--
	ADD	A,16
	OR	#C0
	LD	(SIN1_1+1),A
	LD	(SIN1_2+1),A
	LD	(SIN1_3+1),A
	;---
	LD	H,high BUFF
	LD	C,(IY)
	INC	LY
	LD	B,6 + low BUFF - 1
ROTH	LD	D,0
	EXX
	LD	DE,FLY2DMAP
	;LD	HX,26
	
;shadows size:
;1,1,1,1,1,1,1,1, 8x1
;2,2,2,2,2,2,2,2, 8x2
;3,3,3,3,3,3,3,	  7x3
;2,2,1,0	  2x2, 1
	DUP	8
	CALL	MRT_SHAD_1
	EDUP
	;--
	DUP	8
	CALL	MRT_SHAD_2
	EDUP
	;--
	DUP	7
	CALL	MRT_SHAD_3
	EDUP
	;--
	CALL	MRT_SHAD_2
	CALL	MRT_SHAD_2
	;--
	CALL	MRT_SHAD_1
	;JP	MRT_SHAD_1
;------------------------------------------
MRT_SHAD_1
MRT2_1	;----------------
	LD	LX,32
MRT1_1	;----------------
	EX	DE,HL
	LD	C,(HL)
	INC	L
	LD	B,(HL)
	INC	L	
	EX	DE,HL
	; -- координаты C=x B=y
COS1_1	LD	H,0	;7
	LD	L,C	;4
	LD	A,(HL)	;7 a=(hl)=x*cos(a)
SIN1_1	LD	H,0	;7
	LD	L,B	;4 (hl)=y*sin(a)
	SUB	(HL)	;7 a=y`
MDX_1	ADD	A,0	;7
	OR	#C0	;7
	EX	AF,AF	;4
	;--
	LD	L,C	;4
	LD	A,(HL)	;7 a=(hl)=x*sin(a)
COS2_1	LD	H,0	;7
	LD	L,B	;4
	ADD	A,(HL)	;7
MDY_1	ADD	A,0	;7
	OR	#C0	;7
	LD	B,A	;4
	EX	AF,AF	;4
	LD	C,A	;4
	;--------
	LD	A,(BC)	;7
	;--------
	EXX		;4
	CP	3	;4
	JP	NC,1F 	;10
	;--
	LD	L,B	;4
	LD	(HL),A	;7
	JP	2F
1	;--
	LD	E,A	;7
	;-
	LD	L,C	;4
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	E	;4
	INC	L	;4
	LD	A,(DE)	;7
	LD	(HL),A	;7
	;-
2	INC	H	;4
	EXX		;4 /122
	;----------------
	DEC	LX
	JP	NZ,MRT1_1
	;----------------
	EXX
	LD	H,BUFF / 256
	LD	C,(IY)
	INC	LY
	INC	B
	EXX
	DEC	E
	INC	DE
	;------------------
	;DEC	HX	;8
	;JP	NZ,MRT2_1 ;10 /18
	;------------------
	RET
;------------------------------------------
MRT_SHAD_2
MRT2_2	;----------------
	LD	LX,32
MRT1_2	;----------------
	EX	DE,HL
	LD	C,(HL)
	INC	L
	LD	B,(HL)
	INC	L	
	EX	DE,HL
	; -- координаты C=x B=y
COS1_2	LD	H,0	;7
	LD	L,C	;4
	LD	A,(HL)	;7 a=(hl)=x*cos(a)
SIN1_2	LD	H,0	;7
	LD	L,B	;4 (hl)=y*sin(a)
	SUB	(HL)	;7 a=y`
MDX_2	ADD	A,0	;7
	OR	#C0	;7
	EX	AF,AF	;4
	;--
	LD	L,C	;4
	LD	A,(HL)	;7 a=(hl)=x*sin(a)
COS2_2	LD	H,0	;7
	LD	L,B	;4
	ADD	A,(HL)	;7
MDY_2	ADD	A,0	;7
	OR	#C0	;7
	LD	B,A	;4
	EX	AF,AF	;4
	LD	C,A	;4
	;--------
	LD	A,(BC)	;7
	;--------
	EXX		;4
	CP	3	;4
	JP	NC,1F 	;10
	;--
	LD	L,B	;4
	LD	(HL),A	;7
	JP	2F
1	;--
	LD	E,A	;7
	;-
	LD	L,C	;4
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	E	;4
	INC	L	;4
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	L	;4
	LD	(HL),A	;7 /51
	;-
2	INC	H	;4
	EXX		;4 /122
	;----------------
	DEC	LX
	JP	NZ,MRT1_2
	;----------------
	EXX
	LD	H,BUFF / 256
	LD	C,(IY)
	INC	LY
	INC	B
	EXX
	DEC	E
	INC	DE
	;------------------
	;DEC	HX	;8
	;JP	NZ,MRT2_2 ;10 /18
	;------------------
	RET
;------------------------------------------
MRT_SHAD_3
MRT2_3	;----------------
	LD	LX,32
MRT1_3	;----------------
	EX	DE,HL
	LD	C,(HL)
	INC	L
	LD	B,(HL)
	INC	L	
	EX	DE,HL
	; -- координаты C=x B=y
COS1_3	LD	H,0	;7
	LD	L,C	;4
	LD	A,(HL)	;7 a=(hl)=x*cos(a)
SIN1_3	LD	H,0	;7
	LD	L,B	;4 (hl)=y*sin(a)
	SUB	(HL)	;7 a=y`
MDX_3	ADD	A,0	;7
	OR	#C0	;7
	EX	AF,AF	;4
	;--
	LD	L,C	;4
	LD	A,(HL)	;7 a=(hl)=x*sin(a)
COS2_3	LD	H,0	;7
	LD	L,B	;4
	ADD	A,(HL)	;7
MDY_3	ADD	A,0	;7
	OR	#C0	;7
	LD	B,A	;4
	EX	AF,AF	;4
	LD	C,A	;4
	;--------
	LD	A,(BC)	;7
	;--------
	EXX		;4
	CP	3	;4
	JP	NC,1F 	;10
	;--
	LD	L,B	;4
	LD	(HL),A	;7
	JP	2F
1	;--
	LD	E,A	;7
	;-
	LD	L,C	;4
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	E	;4
	INC	L	;4
	LD	A,(DE)	;7
	LD	(HL),A	;7
	INC	L	;4
	LD	(HL),A	;7
	INC	L	;4
	LD	(HL),A	;7
	;-
2	INC	H	;4
	EXX		;4 /122
	;----------------
	DEC	LX
	JP	NZ,MRT1_3
	;----------------
	EXX
	LD	H,BUFF / 256
	LD	C,(IY)
	INC	LY
	INC	B
	EXX
	DEC	E
	INC	DE
	;------------------
	;DEC	HX	;8
	;JP	NZ,MRT2_3 ;10 /18
	;------------------
	RET
//======================================================== FX_INCLUDE_DATA
	ALIGN	256
FLY2DMAP	INCLUDE "bin/fly2d_map.asm"
//======================================================== FX_TABLES
	ALIGN	256
TXCOR	INCLUDE "bin/fly2d_txcor.asm"
	ALIGN	256
TBL_ROT INCLUDE "bin/tbl_rot.asm"
TBL_MOV_X INCLUDE "bin/tbl_mov_x.asm"
TBL_MOV_Y INCLUDE "bin/tbl_mov_y.asm"

;----------------------------------------------
	ALIGN	256
PAL_A
	DB	#00
	DB	#00
	DB	#01
	DB	#02,#00,#02,#06,#02,#07,#02,#06
	DB	#03,#00,#03,#06,#03,#07,#03,#03
;----------------------------------------------
	ALIGN	256
PAL_AD
	DB	#00
	DB	#00
	DB	#01*8
	DB	#02*8,#00*8,#02*8,#06*8,#02*8,#07*8,#02*8,#06*8
	DB	#03*8,#00*8,#03*8,#06*8,#03*8,#07*8,#03*8,#03*8
;----------------------------------------------
	ALIGN	256
PAL_B
	DB	#40
	DB	#41
	DB	#41
	DB	#40,#42,#42,#42,#46,#42,#47,#47
	DB	#40,#43,#43,#43,#46,#43,#47,#47
;----------------------------------------------
	ALIGN	256
PAL_BD
	DB	#40
	DB	#40+8*1
	DB	#40+8*1
	DB	#40+8*0,#40+8*2,#40+8*2,#40+8*2,#40+8*6,#40+8*2,#40+8*7,#40+8*7
	DB	#40+8*0,#40+8*3,#40+8*3,#40+8*3,#40+8*6,#40+8*3,#40+8*7,#40+8*7


;shadows size:
;1,1,1,1,1,1,1,1, 8x1
;2,2,2,2,2,2,2,2, 8x2
;3,3,3,3,3,3,3,	  7x3
;2,2,1,0	  2x2, 1, 0
TBL_YYY
	DB	YYY - 4 + 0
	DB	YYY - 4 + 1
	DB	YYY - 4 + 2
	DB	YYY - 4 + 3
	DB	YYY - 5 + 4
	DB	YYY - 5 + 5
	DB	YYY - 5 + 6
	DB	YYY - 5 + 7
	DB	YYY - 6 + 8
	DB	YYY - 6 + 9
	DB	YYY - 6 + 10
	DB	YYY - 6 + 11
	DB	YYY - 7 + 12
	DB	YYY - 7 + 13
	DB	YYY - 7 + 14
	DB	YYY - 7 + 15
	DB	YYY - 8 + 16
	DB	YYY - 8 + 17
	DB	YYY - 8 + 18
	DB	YYY - 8 + 19
	DB	YYY - 9 + 20
	DB	YYY - 9 + 21
	DB	YYY - 9 + 22
	DB	YYY - 9 + 23
	DB	YYY - 10 + 24
	DB	YYY - 10 + 25
	DB	YYY - 10 + 26

	
	
	
	
	
	
	
	
	