//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//======================================================== FX_CONST
BUFF_Y		EQU	48
;---
TBL16		EQU	#7F00
;---
BUFFSZ		EQU	32 * BUFF_Y	;1280
BUFF1A		EQU	#7F00 - BUFFSZ
BUFF1B		EQU	BUFF1A - BUFFSZ
BUFF2A		EQU	BUFF1B - BUFFSZ
BUFF2B		EQU	BUFF2A - BUFFSZ
;---
MOVET_ADR	EQU	#DB00
MOVET_ATTR	EQU	#5800
MOVET_SZ	EQU	4*16*BUFF_Y+2


MPG1	EQU	#18
MPG2	EQU	#10
//======================================================== FX_INIT
EFF_INI_
	EI
	HALT
	XOR	A
	OUT	(#FE),A
	
	LD	A,#17
	CALL	PAGER
	
	LD	HL,#4000
	LD	DE,#4001
	LD	(HL),#F0
	LD	BC,6143
	LDIR

	LD	HL,#4000
	LD	DE,#C000
	LD	BC,6912
	LDIR

	LD	HL,BUFF2B
	LD	DE,BUFF2B + 1
	LD	BC,BUFFSZ*4-1
	LD	(HL),0
	LDIR
;-----------
	LD	HL,#7F00
	LD	B,16
	LD	A,L
INI16	LD	(HL),A
	INC	L
	ADD	A,#10
	DJNZ	INI16
;-----------
	CALL	INIMOVE
;-----------
	CALL	SWAPBUFF
	JP	SWP
;-----------
INIMOVE
	LD	HL,MOVET_ADR
	LD	DE,MOVET_ATTR
	LD	LX,BUFF_Y - 38
	CALL	INIMV0
	LD	LX,38
INIMV0	;---
	LD	BC,0-32
INIMV2	;---
	LD	A,16
INIMV1	;---
	LD	(HL),#E1	; pop hl
	INC	HL
	LD	(HL),#22	; ld (adr),hl
	INC	HL
	LD	(HL),E
	INC	HL
	LD	(HL),D
	INC	HL
	INC	E
	INC	DE
	DEC	A
	JP	NZ,INIMV1
	;---
	;#40 = 0100.0000
	;#c0 = 1100.0000
	LD	A,D
	XOR	#80
	LD	D,A
	AND	#80
	JP	Z,INIMV3
	;---
	EX	DE,HL
	ADD	HL,BC
	EX	DE,HL
INIMV3	;---
	DEC	LX
	JP	NZ,INIMV2
	;---
	LD	(HL),#EB	; ex de,hl
	INC	HL
	LD	(HL),#E9	; jp (hl)
	INC	HL
	;---
	RET
//======================================================== FX_MAINLOOP
EFF_RUN_

;378+378+378=1134
;1536-1134=402

	EI
	HALT
	CALL	MOVE_TOP
	LD	IX,27
	LD	HL,MAPTBL
	CALL	MAPPING
	CALL	SWP
	CALL	MOVE_BOTTOM
	
	EI
	HALT
	CALL	MOVE_TOP
	LD	IX,27
	LD	HL,MAPTBL + (27)*14*4
	CALL	MAPPING
	CALL	SWP
	CALL	MOVE_BOTTOM

	EI
	HALT
	CALL	MOVE_TOP
	LD	IX,27
	LD	HL,MAPTBL + (27+27)*14*4
	CALL	MAPPING
	CALL	SWP
	CALL	MOVE_BOTTOM
	
	EI
	HALT
	CALL	MOVE_TOP
	LD	IX,256 + 26
	LD	HL,MAPTBL + (27+27+27)*14*4
	CALL	MAPPING
		;LD	A,1:OUT (#FE),A
	CALL	SWAPBUFF
	CALL	SWP
	CALL	MOVE_BOTTOM
		;LD	A,2:OUT (#FE),A

	RET
//======================================================== FX_PROCEDURES
SWP	LD	A,0
SWP0	EQU	$-1
	XOR	#FF
	LD	(SWP0),A
	LD	HL,0
SWP_BUFFA EQU $-2
	LD	DE,0
SWP_BUFFA_BOTT EQU $-2
	JP	Z,SWP1
	LD	HL,0
SWP_BUFFB EQU $-2
	LD	DE,0
SWP_BUFFB_BOTT EQU $-2
SWP1	LD	(MOVE_TOP_SP),HL
	LD	(MOVE_BOTTOM_SP),DE
	RET
;--------------------------
SWAPBUFF
	LD	A,(MDX)
	ADD	A,1
	AND	63
	LD	(MDX),A

	LD	A,(MDY)
	ADD	A,2
	AND	31
	LD	(MDY),A
	
	
	LD	A,0
SWAPBUFFA EQU $-1
	XOR	#FF
	LD	(SWAPBUFFA),A
	JR	Z,SWAPBUFF1
	;---
	LD	HL,BUFF2A + BUFFSZ - 1
	LD	(MAP_BUFFA),HL
	LD	HL,BUFF2B + BUFFSZ - 1
	LD	(MAP_BUFFB),HL
	;-
	LD	HL,BUFF1A + 32*(BUFF_Y - 38)
	LD	(SWP_BUFFA),HL
	LD	HL,BUFF1B + 32*(BUFF_Y - 38)
	LD	(SWP_BUFFB),HL
	LD	HL,BUFF1A
	LD	(SWP_BUFFA_BOTT),HL
	LD	HL,BUFF1B
	LD	(SWP_BUFFB_BOTT),HL
	RET
SWAPBUFF1 ;---
	LD	HL,BUFF1A + BUFFSZ - 1
	LD	(MAP_BUFFA),HL
	LD	HL,BUFF1B + BUFFSZ - 1
	LD	(MAP_BUFFB),HL
	;-
	LD	HL,BUFF2A + 32*(BUFF_Y - 38)
	LD	(SWP_BUFFA),HL
	LD	HL,BUFF2B + 32*(BUFF_Y - 38)
	LD	(SWP_BUFFB),HL
	LD	HL,BUFF2A
	LD	(SWP_BUFFA_BOTT),HL
	LD	HL,BUFF2B
	LD	(SWP_BUFFB_BOTT),HL
	RET
;--------------------------
MOVE_TOP
	LD	BC,#7FFD
	LD	A,#17
	OUT	(C),A
	;---
	LD	(SOHRSP1),SP
	LD	SP,0
MOVE_TOP_SP	EQU $-2
	LD	DE,MOVE_TOP1
	JP	MOVET_ADR + (BUFF_Y - 38) * 16 * 4  + 2
	
	DISPLAY	"MVTOP ", /A, MOVET_ADR + (BUFF_Y - 38) * 16 * 4 + 2
	
MOVE_TOP1
	LD	SP,0
SOHRSP1	EQU	$-2
	RET
;--------------------------
MOVE_BOTTOM
	LD	BC,#7FFD
	LD	A,#17
	OUT	(C),A
	;---
	LD	(SOHRSP2),SP
	LD	SP,0
MOVE_BOTTOM_SP	EQU $-2
	LD	DE,MOVE_BOTTOM1
	JP	MOVET_ADR
MOVE_BOTTOM1
	LD	SP,0
SOHRSP2	EQU	$-2
	RET
;--------------------------
MAPPING	LD	BC,#7FFD
	LD	A,MPG2
	OUT	(C),A
	;-----
	LD	A,16
	DEC	A
	JP	NZ,$-1
	;-----
	LD	(MAPPING_SOHR_SP),SP
	LD	SP,HL
MAP_MAPTBL EQU $-2
	LD	DE,BUFF1A + BUFFSZ - 1
MAP_BUFFA EQU $-2
	LD	BC,BUFF1B + BUFFSZ - 1
MAP_BUFFB EQU $-2
	LD	H,PALETTE / 256
	EXX
	LD	B,#7F
	LD	DE,0	;mapping scroll, rotate
MDX	EQU	$-2
MDY	EQU	$-1
MAPP1	;---
	DUP	7
	;---
	POP	HL	;10
	ADD	HL,DE	;11
	LD	C,(HL)	;7
	POP	HL	;10
	ADD	HL,DE	;11
	LD	A,(BC)	;7
	OR	(HL)	;7 /63
	;-
	EXX		;4
	LD	L,A	;4
	LD	A,(HL)	;7
	LD	(BC),A	;7
	INC	H	;4
	LDD		;16
	DEC	H	;4
	EXX		;4 /50 //113 * 7 = 791
	;---
	EDUP
	;---
	LD	C,#FD	;7
	LD	A,MPG1	;7
	OUT	(C),A	;12 /26
	;--- w79
	LD A,4
	DEC A
	JP NZ,$-1
	NOP:NOP:NOP:NOP
	;---
	DUP	7
	;---
	POP	HL	;10
	ADD	HL,DE	;11
	LD	C,(HL)	;7
	POP	HL	;10
	ADD	HL,DE	;11
	LD	A,(BC)	;7
	OR	(HL)	;7 /63
	;-
	EXX		;4
	LD	L,A	;4
	LD	A,(HL)	;7
	LD	(BC),A	;7
	INC	H	;4
	LDD		;16
	DEC	H	;4
	EXX		;4 /50 //113 * 7 = 791
	;---
	EDUP
	;---
	LD	C,#FD	;7
	LD	A,MPG2	;7
	OUT	(C),A	;12 /26
	;w61
	LD A,3
	DEC A
	JP NZ,$-1
	NOP:NOP:NOP
	;---
	DEC	LX	 ;8
	JP	NZ,MAPP1 ;10 /18
	;-----------------------
	LD	A,HX
	OR	A
	JP	Z,MAPP2
	;---
	DUP	6
	;---
	POP	HL	;10
	ADD	HL,DE	;11
	LD	C,(HL)	;7
	POP	HL	;10
	ADD	HL,DE	;11
	LD	A,(BC)	;7
	OR	(HL)	;7 /63
	;-
	EXX		;4
	LD	L,A	;4
	LD	A,(HL)	;7
	LD	(BC),A	;7
	INC	H	;4
	LDD		;16
	DEC	H	;4
	EXX		;4 /50 //113 * 7 = 791
	;---
	EDUP
	;---
MAPP2	EXX
	LD	(MAP_BUFFA),DE
	LD	(MAP_BUFFB),BC
	;---------
	LD	SP,0
MAPPING_SOHR_SP	EQU $-2
	RET

//======================================================== FX_INCLUDE_DATA
//======================================================== FX_TABLES
MAPTBL	INCLUDE "bin/map_intor.asm"
	ALIGN	256
PALETTE	INCBIN "bin/palette.bin"


	DISPLAY "MOVE_ADR: ", /A, MOVET_ADR
	DISPLAY "MOVE_SZ: ", /A, MOVET_SZ
	DISPLAY "MOVE_END: ", /A, MOVET_ADR + MOVET_SZ