//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//======================================================== FX_CONST
ALPHAX_STEP	EQU	#0400
ALPHAY_STEP	EQU	#0300
D_MOV_STEP	EQU	#0600	;#0400
D_ROT_STEP	EQU	#0100	;#0100
//======================================================== FX_INIT
EFF_INI_
	LD	HL,#4000
	LD	A,L
	LD	E,6
INI3	LD	C,4
INI2	LD	B,0
INI1	LD	(HL),A
	INC	HL
	DJNZ	INI1
	DEC	C
	JP	NZ,INI2
	XOR	#FF
	DEC	E
	JP	NZ,INI3

	LD	A,#17
	CALL	PAGER
	LD	HL,#4000
	LD	DE,#C000
	LD	BC,6144
	LDIR

	JP	NEXTFRAME
//======================================================== FX_MAINLOOP
EFF_RUN_

	IF SHOW_FRAMES=1
	  LD	A,(FRAMES_QTY)
	  PUSH	AF
	  PUSH	AF
	  XOR	A
	  LD	(FRAMES_QTY),A
	ENDIF

	EI
	HALT
	
	IF SHOW_FRAMES=1
	  POP AF:OUT (#FE),A
	ENDIF

	LD	A,#17
FXPAGE	EQU	$-1
	AND	%11111000
	CALL	PAGER
	CALL	MAKE_TBL

	;CALL	MAKE_TBL_U
	;CALL	MAKE_TBL_V
	
	IF SHOW_FRAMES=1
	  ;LD A,7:OUT (#FE),A
	ENDIF

	LD	A,(FXPAGE)
	CALL	PAGER
	CALL	OUTPUT
	
	IF SHOW_FRAMES=1
	  POP AF:OUT (#FE),A
	ENDIF

	CALL	NEXTFRAME

	IF SHOW_FRAMES=1
		XOR A:OUT (#FE),A
	ENDIF

	RET
	

	
//======================================================== FX_PROCEDURES
NEXTFRAME
	LD	HL,0
ALPHAX	EQU	$-2
	LD	BC,ALPHAX_STEP
	ADD	HL,BC
	LD	(ALPHAX),HL
	LD	A,H
	;-
	LD	H,COS_X/256
	LD	L,A
	LD	A,(HL)
	ADD	A,#C0
	LD	(XY1 + 1),A
	;-
	LD	A,L
	ADD	A,128
	LD	L,A
	LD	A,(HL)
	ADD	A,#C0
	LD	(XY2 + 1),A	
	;-----
	LD	HL,0
ALPHAY	EQU	$-2
	LD	BC,ALPHAY_STEP
	ADD	HL,BC
	LD	(ALPHAY),HL
	LD	A,H
	;--
	LD	H,SIN_Y/256
	LD	L,A
	LD	A,(HL)
	LD	(XY1),A
	;-
	LD	A,L
	ADD	A,64
	LD	L,A
	LD	A,(HL)
	LD	(XY2),A
	;-----
	LD	HL,0
D_MOV_HL EQU $-2
	LD	BC,D_MOV_STEP
	ADD	HL,BC
	LD	(D_MOV_HL),HL
	LD	A,H
	LD	(D_MOV),A
	;---
	LD	HL,0
D_ROT_HL EQU $-2
	LD	BC,D_ROT_STEP
	ADD	HL,BC
	LD	(D_ROT_HL),HL
	LD	A,H
	LD	(D_ROT),A
	;---
	LD	A,(FXPAGE)
	XOR	#08
	LD	(FXPAGE),A
	LD	HL,#D800
	AND	#08
	JR	Z,NEXTF1
	LD	HL,#5800
NEXTF1	LD	(ATTR_ADR),HL
	;--
	RET
XY1	DW	0
XY2	DW	0
;-------------------------------
MAKE_TBL
	LD	BC,TBL
	;-----
	LD	HL,(XY1)
	;-
	LD	DE,(XY2)
	;-
	LD	A,D
	LD	(MT1D),A
	LD	A,H
	LD	(MT1H),A
	;-----
	EXX
	LD	HL,(XY1)
	LD	A,L
	ADD	A,96
	LD	L,A
	LD	DE,(XY2)
	LD	A,E
	ADD	A,96
	LD	E,A
	;-
	LD	A,D
	LD	(MT2D),A
	LD	A,H
	LD	(MT2H),A
	EXX
	;-----
	LD	HX,48
MT1	;-----
	DUP	31
	;-----
	LD	A,(DE)
	SUB	(HL)
	INC	D
	INC	H
	RRA
	RRA
	;AND	%00111111
	LD	(BC),A
	INC	C
	;--
	EXX
	LD	A,(DE)
	SUB	(HL)
	INC	D
	INC	H
	;RRA
	;RRA
	;AND	%00111111
	EXX
	;--
	LD	(BC),A
	INC	C
	;-----
	EDUP
	;-----
	LD	A,(DE)
	SUB	(HL)
	RRA
	RRA
	;AND	%00111111
	LD	(BC),A
	INC	C
	EXX
	LD	A,(DE)
	SUB	(HL)
	LD	D,0
MT2D	EQU	$-1
	INC	E
	LD	H,0
MT2H	EQU	$-1
	INC	L
	;RRA
	;RRA
	;AND	%00111111
	EXX
	;--
	LD	(BC),A
	INC	BC
	;--
	LD	D,0
MT1D	EQU	$-1
	INC	E
	LD	H,0
MT1H	EQU	$-1
	INC	L
	;--
	DEC	HX
	JP	NZ,MT1
	;--
	RET
;-------------------------------
OR_H	EQU	#E0
OUTPUT
	LD	BC,TBL
	LD	HL,#5800
ATTR_ADR EQU	$-2
	LD	LY,24

	LD	IX,0
D_MOV	EQU	$-2
D_ROT	EQU	$-1

OUT1	PUSH	HL
	;--------------- str top
	DUP	31
	;------
	LD	A,(BC)
	INC	C
	ADD	A,HX
	OR	OR_H
	LD	D,A
	;--
	LD	A,(BC)
	INC	C
	ADD	A,LX
	LD	E,A
	;--
	LD	A,(DE)
	AND	%01111000
	LD	(HL),A
	INC	L
	;------
	EDUP
	;---------------
	LD	A,(BC)
	INC	C
	ADD	A,HX
	OR	OR_H
	LD	D,A
	;--
	LD	A,(BC)
	INC	BC
	ADD	A,LX
	LD	E,A
	;--
	LD	A,(DE)
	AND	%01111000
	LD	(HL),A
	;--------------- str down
	POP	HL
	;------
	DUP	31
	;------
	LD	A,(BC)
	INC	C
	ADD	A,HX
	OR	OR_H
	LD	D,A
	;--
	LD	A,(BC)
	INC	C
	ADD	A,LX
	LD	E,A
	;--
	LD	A,(DE)
	AND	%01000111
	OR	(HL)
	LD	(HL),A
	INC	L
	;------
	EDUP
	;------
	LD	A,(BC)
	INC	C
	ADD	A,HX
	OR	OR_H
	LD	D,A
	;--
	LD	A,(BC)
	INC	BC
	ADD	A,LX
	LD	E,A
	;--
	LD	A,(DE)
	AND	%01000111
	OR	(HL)
	LD	(HL),A
	INC	HL
	;--
	DEC	LY
	JP	NZ,OUT1
	;--
	RET
//======================================================== FX_INCLUDE_DATA
//======================================================== FX_TABLES
	ALIGN 256
COS_X	INCBIN "bin/duo_tunnel_cos_x.bin"
SIN_Y	INCBIN "bin/duo_tunnel_sin_y.bin"
TBL

