//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
using Framefield.Core.IDb03022e3_8b4f_4d33_b749_ef30a03ef098; // CurveProviderFunc
//<<< _using


using Buffer = SharpDX.Direct3D11.Buffer;

namespace Framefield.Core.IDea77aa22_2349_44bb_918c_c0d4d30be9ac
{
    public class Class__SampleValueMesh : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            Value = 0,
            LineWidth = 1,
            ColorR = 2,
            ColorG = 3,
            ColorB = 4,
            ColorA = 5,
            MaxSteps = 6,
            SampleTime = 7,
            SampleRangeEnd = 8,
            SampleRangeStart = 9,
            GraphWidth = 10,
            RangeVMin = 11,
            RangeVMax = 12
        }
        //<<< _inputids
        
        //>>> _outputids
        private enum OutputId
        {
            Out = 0,
            MinValue = 1,
            MaxValue = 2,
            LastValue = 3
        }
        //<<< _outputids
        
        public override void Dispose() {
            Utilities.DisposeObj(ref _planeMesh);
        }

        
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {

            //>>> _params
            var Value = inputs[(int)InputId.Value].Eval(context).Value;
            var LineWidth = inputs[(int)InputId.LineWidth].Eval(context).Value;
            var ColorR = inputs[(int)InputId.ColorR].Eval(context).Value;
            var ColorG = inputs[(int)InputId.ColorG].Eval(context).Value;
            var ColorB = inputs[(int)InputId.ColorB].Eval(context).Value;
            var ColorA = inputs[(int)InputId.ColorA].Eval(context).Value;
            var Color = new Color4(ColorR, ColorG, ColorB, ColorA);
            var MaxSteps = inputs[(int)InputId.MaxSteps].Eval(context).Value;
            var SampleTime = inputs[(int)InputId.SampleTime].Eval(context).Value;
            var SampleRangeEnd = inputs[(int)InputId.SampleRangeEnd].Eval(context).Value;
            var SampleRangeStart = inputs[(int)InputId.SampleRangeStart].Eval(context).Value;
            var SampleRange = new Vector2(SampleRangeEnd, SampleRangeStart);
            var GraphWidth = inputs[(int)InputId.GraphWidth].Eval(context).Value;
            var RangeVMin = inputs[(int)InputId.RangeVMin].Eval(context).Value;
            var RangeVMax = inputs[(int)InputId.RangeVMax].Eval(context).Value;
            var RangeV = new Vector2(RangeVMin, RangeVMax);
            //<<< _params
            
            if(Changed) 
            {
                if((int)MaxSteps != _maxSteps) 
                {
                    _maxSteps = (int)(Math.Max( MaxSteps, 10));
                    _plotValues = new float[_maxSteps];
                }                        
                
                //_lastTime = SampleTime;                 
                _color = Color;
                _lineWidth = LineWidth;
                _graphWidth = GraphWidth;
                _minValue = float.PositiveInfinity;
                _maxValue = float.NegativeInfinity;
    
                var valueInput = inputs[(int)InputId.Value];
                var previousTime = context.Time;
    
                OperatorPart.ChangedPropagationEnabled = false;
    
                //var loopCounter = 0;
                var invalidator = new OperatorPart.InvalidateTimeAccessors();
                for (var i = 0; i < _maxSteps; i++)
                {                       
                    // Invalidate all time accessors
                    valueInput.TraverseWithFunction(null, invalidator);                    
                    
                    var f= i/(float)_maxSteps;
                    
                    context.Time = SampleTime + Utilities.Lerp(SampleRangeStart, SampleRangeEnd, f);                    
                    var v= valueInput.Eval(context).Value;
                    _minValue = (float)Math.Min(v, _minValue);
                    _maxValue = (float)Math.Max(v, _maxValue);                
                    _plotValues[i] = v;
                    
                }
                //Logger.Info("MinValue:" + _minValue + "  " + _maxValue);
                
                OperatorPart.ChangedPropagationEnabled = true;
                
                //var invalidator = new OperatorPart.InvalidateTimeAccessors();
                valueInput.TraverseWithFunction(null, invalidator);                    

                context.Time = previousTime;
                Changed =false;
            }
            
            if( RangeVMax == RangeVMin) 
            {           
                _dampedMinValue = Utilities.Lerp( _minValue, _dampedMinValue, _friction);
                _dampedMaxValue = Utilities.Lerp( _maxValue, _dampedMaxValue, _friction);
            }
            else {
                _dampedMinValue = RangeVMin;
                _dampedMaxValue = RangeVMax;
            }
            
            UpdateMesh(context);
            
            switch( (int) outputIdx) {
                case (int)OutputId.Out: 
                    if(_plotValues.Length > 2) {
                        context.Renderer.SetupEffect(context);
                        context.Renderer.Render(_planeMesh, context);                
                    }
                    break;
                    
                case (int)OutputId.MinValue: 
                    context.Value= _dampedMinValue; 
                    break;
                    
                case (int)OutputId.MaxValue: 
                    context.Value= _dampedMaxValue; 
                    break;
                    
                case (int)OutputId.LastValue: 
                    context.Value= _plotValues[0]; 
                    break;
                    
            }            
            return context;
        }


        private void UpdateMesh(OperatorPartContext context) 
        {
            var normal = new Vector3(0.0f, 0.0f, -1.0f);
            //var color = Color;
            var tangent = new Vector3(1.0f, 0.0f, 0.0f);
            var binormal = new Vector3(0.0f, -1.0f, 0.0f);
                
            var inputElements = new InputElement[] {
                new InputElement("POSITION", 0, SharpDX.DXGI.Format.R32G32B32A32_Float, 0, 0),
                new InputElement("NORMAL", 0, SharpDX.DXGI.Format.R32G32B32_Float, 16, 0),
                new InputElement("COLOR", 0, SharpDX.DXGI.Format.R32G32B32A32_Float, 28, 0),
                new InputElement("TEXCOORD", 0, SharpDX.DXGI.Format.R32G32_Float, 44, 0),
                new InputElement("TANGENT", 0, SharpDX.DXGI.Format.R32G32B32_Float, 52, 0),
                new InputElement("BINORMAL", 0, SharpDX.DXGI.Format.R32G32B32_Float, 64, 0)
            };
            
            if (_plotValues.Length < 2)
                return;
                        
            // Setup vertex-structure
            const int attributesSize = 76;
            int numTriangles = (_plotValues.Length - 1) *2;
            int streamSize = numTriangles * 3 * attributesSize;

            if (_planeMesh == null || streamSize != _planeMesh.Vertices.Description.SizeInBytes) 
            {
                Utilities.DisposeObj(ref _planeMesh);
                using (var stream = new DataStream(streamSize, true, true))
                {
                    var vertices = new Buffer(context.D3DDevice, stream, new BufferDescription
                                       {
                                           BindFlags = BindFlags.VertexBuffer,
                                           CpuAccessFlags = CpuAccessFlags.Write,
                                           OptionFlags = ResourceOptionFlags.None,
                                           SizeInBytes = streamSize,
                                           Usage = ResourceUsage.Dynamic
                                       });
                    _planeMesh = new Mesh { InputElements = inputElements, Vertices = vertices, NumTriangles = numTriangles, AttributesSize = attributesSize };
                }
            }
            if (_planeMesh.NumTriangles != numTriangles)
            {
                _planeMesh.NumTriangles = numTriangles;
            }

            DataStream vertexStream;
            DataBox box = context.D3DDevice.ImmediateContext.MapSubresource(_planeMesh.Vertices, MapMode.WriteDiscard, MapFlags.None, out vertexStream);
            using (vertexStream)
            {
                vertexStream.Position = 0;
                
                Vector4 lastP0= new Vector4(0,0,0,1);;
                Vector4 lastP1= new Vector4(0,0,0,1);;
                
                int index = 0;
                var valueRange = (float)Math.Max(0.001f, (float)_dampedMaxValue - _dampedMinValue);
                
                foreach(float val in _plotValues) 
                {
                    var f = index/(float)_maxSteps;
                    var t = f * _graphWidth;
                    
                    var v = (val - _dampedMinValue) / valueRange - 0.5f;
                    
                    var nextP0 = new Vector4((float)t,v-_lineWidth,0,1);
                    var nextP1 = new Vector4((float)t,v+_lineWidth,0,1);                    
                    
                    if(index > 0) 
                    {                    
                        float u= index/(float)_plotValues.Length;
    
                        // tri 1 vert 1
                        vertexStream.Write(lastP0);
                        vertexStream.Write(normal);
                        vertexStream.Write(_color);
                        vertexStream.Write( new Vector2(u,0));
                        vertexStream.Write(tangent);
                        vertexStream.Write(binormal);
    
                        // tri 1 vert 2
                        vertexStream.Write(nextP0);
                        vertexStream.Write(normal);
                        vertexStream.Write(_color);
                        vertexStream.Write(new Vector2(u, 1));
                        vertexStream.Write(tangent);
                        vertexStream.Write(binormal);
    
                        // tri 1 vert 3
                        vertexStream.Write(lastP1);
                        vertexStream.Write(normal);
                        vertexStream.Write(_color);
                        vertexStream.Write(new Vector2(u, 0));
                        vertexStream.Write(tangent);
                        vertexStream.Write(binormal);
    
                        // tri 2 vert 1
                        vertexStream.Write(nextP0);
                        vertexStream.Write(normal);
                        vertexStream.Write(_color);
                        vertexStream.Write(new Vector2(u, 1));
                        vertexStream.Write(tangent);
                        vertexStream.Write(binormal);
    
                        // tri 2 vert 2
                        vertexStream.Write(nextP1);
                        vertexStream.Write(normal);
                        vertexStream.Write(_color);
                        vertexStream.Write(new Vector2(u, 1));
                        vertexStream.Write(tangent);
                        vertexStream.Write(binormal);
    
                        // tri 2 vert 3
                        vertexStream.Write(lastP1);
                        vertexStream.Write(normal);
                        vertexStream.Write(_color);
                        vertexStream.Write(new Vector2(u, 0));
                        vertexStream.Write(tangent);
                        vertexStream.Write(binormal);
                    }
                    index++;
                    
                    lastP0 = nextP0;
                    lastP1 = nextP1;
                }
                context.D3DDevice.ImmediateContext.UnmapSubresource(_planeMesh.Vertices, 0);
            }        
        }
        
        private double _lastTime;
        private Vector4 _color;
        private float _minValue;
        private float _maxValue;
        private float _dampedMinValue;
        private float _dampedMaxValue;
        private float _lineWidth;
        private float _graphWidth= 1;
        private float _friction= 0.96f;
        //private SortedList<double, float> _valuesOverTime = new SortedList<double,float>();        
        //private PlotValue[] _plotValues = new PlotValue[1];
        //private List<PlotValue> _plotValues = new List<PlotValue>();
        private float[] _plotValues = new float[10];
        int _maxSteps = 10;
        Vector3 _up;
        
        /*
        struct PlotValue 
        {
            public double t;
            public float v;
        }
        */
        
        //ICurveProvider  _curve;

        private Mesh _planeMesh;
    }
}