//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
using Framefield.Core.IDb03022e3_8b4f_4d33_b749_ef30a03ef098; // CurveProviderFunc
//<<< _using


using Buffer = SharpDX.Direct3D11.Buffer;

namespace Framefield.Core.ID9a7779c8_21de_4835_9197_4b1f4a61ba18
{
    public class Class__PlotValueMesh : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            Value = 0,
            UVMode = 1,
            Width = 2,
            ColorR = 3,
            ColorG = 4,
            ColorB = 5,
            ColorA = 6,
            MaxSteps = 7,
            RangeStart = 8,
            RangeEnd = 9
        }
        //<<< _inputids
        
        //>>> _outputids
        private enum OutputId
        {
            Out = 0,
            MinValue = 1,
            MaxValue = 2
        }
        //<<< _outputids
        
        public override void Dispose() {
            Utilities.DisposeObj(ref _planeMesh);
        }

        
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {

            //>>> _params
            var Value = inputs[(int)InputId.Value].Eval(context).Value;
            var UVMode = (int) inputs[(int)InputId.UVMode].Eval(context).Value;
            var Width = inputs[(int)InputId.Width].Eval(context).Value;
            var ColorR = inputs[(int)InputId.ColorR].Eval(context).Value;
            var ColorG = inputs[(int)InputId.ColorG].Eval(context).Value;
            var ColorB = inputs[(int)InputId.ColorB].Eval(context).Value;
            var ColorA = inputs[(int)InputId.ColorA].Eval(context).Value;
            var Color = new Color4(ColorR, ColorG, ColorB, ColorA);
            var MaxSteps = inputs[(int)InputId.MaxSteps].Eval(context).Value;
            var RangeStart = inputs[(int)InputId.RangeStart].Eval(context).Value;
            var RangeEnd = inputs[(int)InputId.RangeEnd].Eval(context).Value;
            var Range = new Vector2(RangeStart, RangeEnd);
            //<<< _params
            
            //if((int)MaxSteps != _maxSteps) {
            //    _maxSteps = (int)Math.Max(MaxSteps,2);
            //    _plotValues = new PlotValue[_maxSteps];
            //}
            
            if(context.GlobalTime != _lastTime) 
            {
                _lastTime = context.GlobalTime;                 
                _color = Color;    
                _maxSteps = (int)MaxSteps;

                //_valuesOverTime[_lastTime] = Value;
                var pv = new PlotValue();
                pv.t = _lastTime;
                pv.v = Value;
                
                _plotValues.Add(pv);
                //Logger.Info("v:" + _valuesOverTime.Count);
                LimitListSize();
                UpdateMesh(context);
                
                if(_minValue == _maxValue) {
                    _minValue -=1;
                    _maxValue +=1;
                }
                _dampedMinValue = Utilities.Lerp( _minValue, _dampedMinValue, _friction);
                _dampedMaxValue = Utilities.Lerp( _maxValue, _dampedMaxValue, _friction);

            }

            //context.Renderer.SetupEffect(context);
            //context.Renderer.Render(_planeMesh, context);
            
            switch( (int) outputIdx) {
                case (int)OutputId.Out: 
                    if(_plotValues.Count > 2) {
                        context.Renderer.SetupEffect(context);
                        context.Renderer.Render(_planeMesh, context);                
                    }
                    break;
                    
                case (int)OutputId.MinValue: context.Value= _dampedMinValue; break;
                case (int)OutputId.MaxValue: context.Value= _dampedMaxValue; break;
            }            
            return context;
        }
        

        private void LimitListSize() 
        {
            if(_maxSteps < 1)
                return;            
                
            while( _plotValues.Count > _maxSteps) 
            {
                _plotValues.RemoveAt(0);
            }
        }
        


        private void UpdateMesh(OperatorPartContext context) 
        {
            var normal = new Vector3(0.0f, 0.0f, -1.0f);
            //var color = Color;
            var tangent = new Vector3(1.0f, 0.0f, 0.0f);
            var binormal = new Vector3(0.0f, -1.0f, 0.0f);
                
            var inputElements = new InputElement[] {
                new InputElement("POSITION", 0, SharpDX.DXGI.Format.R32G32B32A32_Float, 0, 0),
                new InputElement("NORMAL", 0, SharpDX.DXGI.Format.R32G32B32_Float, 16, 0),
                new InputElement("COLOR", 0, SharpDX.DXGI.Format.R32G32B32A32_Float, 28, 0),
                new InputElement("TEXCOORD", 0, SharpDX.DXGI.Format.R32G32_Float, 44, 0),
                new InputElement("TANGENT", 0, SharpDX.DXGI.Format.R32G32B32_Float, 52, 0),
                new InputElement("BINORMAL", 0, SharpDX.DXGI.Format.R32G32B32_Float, 64, 0)
            };
            
            if (_plotValues.Count < 2)
                return;
                        
            // Setup vertex-structure
            const int attributesSize = 76;
            int numTriangles = (_plotValues.Count-1) *2;
            int streamSize = numTriangles * 3 * attributesSize;

            if (_planeMesh == null || streamSize != _planeMesh.Vertices.Description.SizeInBytes) 
            {
                Utilities.DisposeObj(ref _planeMesh);
                using (var stream = new DataStream(streamSize, true, true))
                {
                    var vertices = new Buffer(context.D3DDevice, stream, new BufferDescription
                                       {
                                           BindFlags = BindFlags.VertexBuffer,
                                           CpuAccessFlags = CpuAccessFlags.Write,
                                           OptionFlags = ResourceOptionFlags.None,
                                           SizeInBytes = streamSize,
                                           Usage = ResourceUsage.Dynamic
                                       });
                    _planeMesh = new Mesh { InputElements = inputElements, Vertices = vertices, NumTriangles = numTriangles, AttributesSize = attributesSize };
                }
            }
            if (_planeMesh.NumTriangles != numTriangles)
            {
                _planeMesh.NumTriangles = numTriangles;
            }

            DataStream vertexStream;
            DataBox box = context.D3DDevice.ImmediateContext.MapSubresource(_planeMesh.Vertices, MapMode.WriteDiscard, MapFlags.None, out vertexStream);
            using (vertexStream)
            {
                vertexStream.Position = 0;

                //float uShift = _paintedLength;
                _maxValue = float.NegativeInfinity;
                _minValue = float.PositiveInfinity;
                
                Vector4 lastP0= new Vector4(0,0,0,1);;
                Vector4 lastP1= new Vector4(0,0,0,1);;
                
                int index = 0;
                
                foreach(var pv in _plotValues) 
                {
                    var t = pv.t;
                    var v = pv.v;                    
                    //Logger.Info(" " + t + " : " + v); 
                    
                    if(v > _maxValue) {  _maxValue = v; }
                    if(v < _minValue) {  _minValue = v; }
                    
                    var nextP0 = new Vector4((float)t,v-_width,0,1);
                    var nextP1 = new Vector4((float)t,v+_width,0,1);                    
                    
                    if(index > 0) 
                    {                    
                        float u= index/(float)_plotValues.Count;
    
                        // tri 1 vert 1
                        vertexStream.Write(lastP0);
                        vertexStream.Write(normal);
                        vertexStream.Write(_color);
                        vertexStream.Write( new Vector2(u,0));
                        vertexStream.Write(tangent);
                        vertexStream.Write(binormal);
    
                        // tri 1 vert 2
                        vertexStream.Write(nextP0);
                        vertexStream.Write(normal);
                        vertexStream.Write(_color);
                        vertexStream.Write(new Vector2(u, 1));
                        vertexStream.Write(tangent);
                        vertexStream.Write(binormal);
    
                        // tri 1 vert 3
                        vertexStream.Write(lastP1);
                        vertexStream.Write(normal);
                        vertexStream.Write(_color);
                        vertexStream.Write(new Vector2(u, 0));
                        vertexStream.Write(tangent);
                        vertexStream.Write(binormal);
    
                        // tri 2 vert 1
                        vertexStream.Write(nextP0);
                        vertexStream.Write(normal);
                        vertexStream.Write(_color);
                        vertexStream.Write(new Vector2(u, 1));
                        vertexStream.Write(tangent);
                        vertexStream.Write(binormal);
    
                        // tri 2 vert 2
                        vertexStream.Write(nextP1);
                        vertexStream.Write(normal);
                        vertexStream.Write(_color);
                        vertexStream.Write(new Vector2(u, 1));
                        vertexStream.Write(tangent);
                        vertexStream.Write(binormal);
    
                        // tri 2 vert 3
                        vertexStream.Write(lastP1);
                        vertexStream.Write(normal);
                        vertexStream.Write(_color);
                        vertexStream.Write(new Vector2(u, 0));
                        vertexStream.Write(tangent);
                        vertexStream.Write(binormal);
                    }
                    index++;
                    
                    lastP0 = nextP0;
                    lastP1 = nextP1;
                }
                context.D3DDevice.ImmediateContext.UnmapSubresource(_planeMesh.Vertices, 0);
            }        
        }
        
        private double _lastTime;
        private Vector4 _color;
        private float _minValue;
        private float _maxValue;
        private float _width;
        
        private float _dampedMinValue=-1;
        private float _dampedMaxValue=1;
        private float _friction = 0.96f;

        //private SortedList<double, float> _valuesOverTime = new SortedList<double,float>();        
        //private PlotValue[] _plotValues = new PlotValue[1];
        private List<PlotValue> _plotValues = new List<PlotValue>();
        int _maxSteps = 10;
        Vector3 _up;
        
        struct PlotValue 
        {
            public double t;
            public float v;
        }
        
        //ICurveProvider  _curve;

        private Mesh _planeMesh;
    }
}