//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using


namespace Framefield.Core.ID5d7c8b19_dc44_461b_aae1_cbd3a659e4bd
{
    public class Class_WrapText : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            InputString = 0,
            MaxLength = 1
        }
        //<<< _inputids


        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var InputString = inputs[(int)InputId.InputString].Eval(context).Text;
            var MaxLength = inputs[(int)InputId.MaxLength].Eval(context).Value;
            //<<< _params            
            string result = string.Empty;
            
            StringBuilder resultBuider = new StringBuilder();
            var lineLength = 0;
            foreach( var word in  InputString.Split(' ')) {
            
                lineLength += word.Length;
                if(lineLength > MaxLength) {
                    resultBuider.Append("\n");
                    lineLength = 0;
                }
                resultBuider.Append(word);
                resultBuider.Append(" ");
            }            
            context.Text = resultBuider.ToString();            
            return context;
        }
    }
}

