//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

using WebSocket4Net;
using System.Threading;

namespace Framefield.Core.ID52158493_c00e_488e_b9f4_16b5bdbf32b3
{
    public class Class_WebSocket : OperatorPart.Function, Framefield.Core.OperatorPartTraits.ITimeAccessor
    {
        //>>> _inputids
        private enum InputId
        {
            URL = 0
        }
        //<<< _inputids


        private void setupWebSocket(string url) {
            if (_webSocket != null) {
                _webSocket.MessageReceived -= HandleReceivedMessage;
                _webSocket.Closed -= websocket_Closed;
                _webSocket.Error -= websocket_Error;
                _webSocket.Opened -= websocket_Opened;
                _webSocket.Close();
            }

            _webSocket = new WebSocket(url);
            _url = url;

            _webSocket.MessageReceived += new EventHandler<MessageReceivedEventArgs>(HandleReceivedMessage);
            _webSocket.Closed += new EventHandler(websocket_Closed);
            _webSocket.Error += new EventHandler<SuperSocket.ClientEngine.ErrorEventArgs>(websocket_Error);
            _webSocket.Opened += new EventHandler(websocket_Opened);
            _webSocket.Open();
        }

        private static ManualResetEvent m_ClosedEvent = new ManualResetEvent(false);

        private const int m_TimerSpan = 5;

        void websocket_Opened(object sender, EventArgs e) {
            lock (_resultBuilder) {
                string timestamp = "5711";
                string game = "53";
                string action = "start";
                string message = "{\"Timestamp\":\"" + timestamp + "\",\"Game\":\"" + game + "\",\"Action\":\"" + action + "\"}";
                _webSocket.Send(message);
            }
        }

        private void websocket_Error(object sender, SuperSocket.ClientEngine.ErrorEventArgs e) {
        }

        private void websocket_Closed(object sender, EventArgs e) {
        }

        private void HandleReceivedMessage(object sender, MessageReceivedEventArgs args) {
            lock (_resultBuilder) {
                _resultBuilder.Append(args.Message);
            }
        }


        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var URL = inputs[(int)InputId.URL].Eval(context).Text;
            //<<< _params

            if (URL != _url) {
                setupWebSocket(URL);
            }

            lock (_resultBuilder) {
                context.Text = _resultBuilder.ToString();
                _resultBuilder.Clear();
            }
            return context;
        }

        WebSocket _webSocket = null;
        string _url = string.Empty;
        StringBuilder _resultBuilder = new StringBuilder();
    }
}

