//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID69643dc6_84e6_4d36_95f4_e08eb6819287
{
    public class Class_TestValue : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            Value = 0,
            Threshold = 1,
            Mode = 2,
            FallbackValue = 3
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Value = inputs[(int)InputId.Value].Eval(context).Value;
            var Threshold = inputs[(int)InputId.Threshold].Eval(context).Value;
            var Mode = (int) inputs[(int)InputId.Mode].Eval(context).Value;
            var FallbackValue = inputs[(int)InputId.FallbackValue].Eval(context).Value;
            //<<< _params
                               
            switch ((int)Mode)
            {
                case 0: context.Value = Value < Threshold ? Value : FallbackValue; break;
                case 1: context.Value = Value > Threshold ? Value : FallbackValue; break;
            }
            return context;
        }
    }
}

