using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;

namespace Framefield.Core.IDa4daff2b_6e24_45cc_8c91_57c953f61740
{
    public class Class_TimeMarker : OperatorPart.Function, Framefield.Core.OperatorPartTraits.ITimeMarker
    {
        public double Time {
            get { return GetInputValue(0); }
            set { SetInputValue(0, value); }
        }


        public Color4 Color {
            get {
                return new Color4((float)GetInputValue(4),
                                  (float)GetInputValue(1),
                                  (float)GetInputValue(2),
                                  (float)GetInputValue(3));
            }
            set {
                SetInputValue(1, (double)value.Alpha);
                SetInputValue(2, (double)value.Red);
                SetInputValue(3, (double)value.Green);
                SetInputValue(4, (double)value.Blue);
            }
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            foreach (var input in inputs)
                input.Eval(context);
            return context;
        }

        private double GetInputValue(int index) {
            return OperatorPartUtilities.GetInputFloatValue(OperatorPart.Connections[index]);
        }

        private void SetInputValue(int index, double val) {
            OperatorPart opPart = OperatorPart.Connections[index];
            if (opPart.Connections.Count == 0) {
                opPart.Func = Utilities.CreateValueFunction(new Float((float)val));
            }
        }

    }
}
