//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using Framefield.Core.OperatorPartTraits;
using Framefield.Core.Rendering;
using Buffer = SharpDX.Direct3D11.Buffer;
using SharpDX.Direct3D;

namespace Framefield.Core.IDb9868ce7_1f21_4ff6_9239_9b5942e1f182
{
    public class Class_ThreadSqueeze : FXSourceCodeFunction, IFXSceneSourceCode
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Mesh = 1,
            Facetize = 2,
            ScaleNormals = 3,
            SqueezeTop = 4,
            SqueezeCenter = 5,
            SqueezeBottom = 6,
            Wiggle = 7,
            WiggleFrequency = 8,
            WigglePhase = 9,
            SkaleUp = 10
        }
        //<<< _inputids

        public Class_ThreadSqueeze()
        {
        }

        public override void Dispose() 
        {
            Utilities.DisposeObj(ref _mesh);
            base.Dispose();
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            try
            {
                UpdateMesh(context, inputs);
                context.Mesh = _mesh;
            }
            catch (Exception exception)
            {
                Logger.Error(this, "Load Effect error: {0}", exception.Message);
            }

            return context;
        }

        bool _firstEval = true;
        private void UpdateMesh(OperatorPartContext context, List<OperatorPart> inputs)
        {
            if (_firstEval)
            {
                for (int i = 0; i < NumCodes(); ++i)
                    Compile(i);
                _firstEval = false;
                Changed = true;
            }

            if (!Changed && _mesh.Vertices != null)
                return;

            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Mesh = inputs[(int)InputId.Mesh].Eval(context).Mesh;
            var Facetize = inputs[(int)InputId.Facetize].Eval(context).Value;
            var ScaleNormals = inputs[(int)InputId.ScaleNormals].Eval(context).Value;
            var SqueezeTop = inputs[(int)InputId.SqueezeTop].Eval(context).Value;
            var SqueezeCenter = inputs[(int)InputId.SqueezeCenter].Eval(context).Value;
            var SqueezeBottom = inputs[(int)InputId.SqueezeBottom].Eval(context).Value;
            var Wiggle = inputs[(int)InputId.Wiggle].Eval(context).Value;
            var WiggleFrequency = inputs[(int)InputId.WiggleFrequency].Eval(context).Value;
            var WigglePhase = inputs[(int)InputId.WigglePhase].Eval(context).Value;
            var SkaleUp = inputs[(int)InputId.SkaleUp].Eval(context).Value;
            //<<< _params


            if (Mesh == null)
                return;

            _mesh.AttributesSize = Mesh.AttributesSize;
            _mesh.NumTriangles = Mesh.NumTriangles;
            _mesh.InputElements = Mesh.InputElements;
            if (_mesh.Vertices == null || _mesh.Vertices.Description.SizeInBytes != Mesh.Vertices.Description.SizeInBytes)
            {
                if (_mesh.Vertices != null)
                    _mesh.Vertices.Dispose();

                _mesh.Vertices = new Buffer(D3DDevice.Device, new BufferDescription()
                                                                    {
                                                                        BindFlags = BindFlags.StreamOutput | BindFlags.VertexBuffer,
                                                                        CpuAccessFlags = CpuAccessFlags.None,
                                                                        OptionFlags = ResourceOptionFlags.None,
                                                                        SizeInBytes = _mesh.NumTriangles*Mesh.AttributesSize*3,
                                                                        Usage = ResourceUsage.Default
                                                                    });
            }
            
            //var textureView = new ShaderResourceView(D3DDevice, NoiseTexture);
            //var noiseTextureView = new ShaderResourceView(context.D3DDevice, NoiseTexture);
            //_effect.GetVariableByName("NoiseTexture").AsShaderResource().SetResource(noiseTextureView);

            /*
            _effect.GetVariableByName("Facetize").AsScalar().Set(Facetize);
            _effect.GetVariableByName("ScaleNormals").AsScalar().Set(ScaleNormals);
            _effect.GetVariableByName("SqueezeTop").AsScalar().Set(SqueezeTop);   
            _effect.GetVariableByName("SqueezeBottom").AsScalar().Set(SqueezeBottom);   
            _effect.GetVariableByName("SqueezeCenter").AsScalar().Set(SqueezeCenter);   
            _effect.GetVariableByName("Wiggle").AsScalar().Set(Wiggle);   
            _effect.GetVariableByName("WiggleFrequency").AsScalar().Set(WiggleFrequency);   
            _effect.GetVariableByName("WigglePhase").AsScalar().Set(WigglePhase); 
*/
            var _usedViewport = context.Viewport;
            //>>> _setup
            {
                _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                _effect.GetVariableByName("Facetize").AsScalar().Set(Facetize);
                _effect.GetVariableByName("ScaleNormals").AsScalar().Set(ScaleNormals);
                _effect.GetVariableByName("SqueezeTop").AsScalar().Set(SqueezeTop);
                _effect.GetVariableByName("SqueezeCenter").AsScalar().Set(SqueezeCenter);
                _effect.GetVariableByName("SqueezeBottom").AsScalar().Set(SqueezeBottom);
                _effect.GetVariableByName("Wiggle").AsScalar().Set(Wiggle);
                _effect.GetVariableByName("WiggleFrequency").AsScalar().Set(WiggleFrequency);
                _effect.GetVariableByName("WigglePhase").AsScalar().Set(WigglePhase);
                _effect.GetVariableByName("SkaleUp").AsScalar().Set(SkaleUp);
            //<<< _setup
            //_effect.GetVariableByName("NoiseAmountXYZ").AsVector().Set(new Vector3(NoiseAmountXYZ.X, NoiseAmountXYZ.Y, NoiseAmountXYZ.Z));
            }
            context.D3DDevice.ImmediateContext.StreamOutput.SetTargets(new [] { new StreamOutputBufferBinding(_mesh.Vertices, 0) });
            context.D3DDevice.ImmediateContext.OutputMerger.DepthStencilState = new DepthStencilState(context.D3DDevice,
                                                                                                        new DepthStencilStateDescription()
                                                                                                            {
                                                                                                                IsDepthEnabled = false,
                                                                                                                IsStencilEnabled = false
                                                                                                            });
            context.D3DDevice.ImmediateContext.InputAssembler.InputLayout = context.InputLayout;
            context.D3DDevice.ImmediateContext.InputAssembler.PrimitiveTopology = PrimitiveTopology.TriangleList;
            context.D3DDevice.ImmediateContext.InputAssembler.SetVertexBuffers(0, new VertexBufferBinding(Mesh.Vertices, Mesh.AttributesSize, 0));
            var technique = _effect.GetTechniqueByIndex(0);
            technique.GetPassByIndex(0).Apply(context.D3DDevice.ImmediateContext);
            context.D3DDevice.ImmediateContext.Draw(_mesh.NumTriangles*3, 0);
            context.D3DDevice.ImmediateContext.StreamOutput.SetTargets(new [] { new StreamOutputBufferBinding(null, 0) });

            Changed = false;
        }

        private Mesh _mesh = new Mesh();
    }
}


