//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDd5cadb89_3869_4314_a2ab_80aed78f15da
{
    public class Class_StripeHalftoneStripes : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            linesRows = 1,
            Thickness = 2,
            Angle = 3
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var linesRows = inputs[(int)InputId.linesRows].Eval(context).Value;
            var Thickness = inputs[(int)InputId.Thickness].Eval(context).Value;
            var Angle = inputs[(int)InputId.Angle].Eval(context).Value;
            //<<< _params
            
//            if(Image == null)
//                return context;

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("linesRows").AsScalar().Set(linesRows);
                    _effect.GetVariableByName("Thickness").AsScalar().Set(Thickness);
                    _effect.GetVariableByName("Angle").AsScalar().Set(Angle);
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

