using System;
using System.Collections.Generic;
using System.Dynamic;
using System.Linq;
using System.Text;
using System.Xml;
using SharpDX;


using System.IO;

namespace Framefield.Core.IDce0035a7_336e_4e64_97e8_ff0fbcd0a3a6
{
    public class Class_StringFromFile : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            FilePath = 0
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var FilePath = inputs[(int)InputId.FilePath].Eval(context).Text;
            //<<< _params

            if( FilePath != _filePath) 
            {
                _filePath = FilePath;
                if( File.Exists(_filePath)) {
                    _content= File.ReadAllText(_filePath);
                    Logger.Info(this,"New content: {0}", _content);
                }
                else {
                    Logger.Warn(this,"File not found: {0}", _filePath);
                }
            }
            
            context.Text = _content;
            return context;
        }
        
        String _content = "";
        String _filePath = "";
    }
}

