//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID5d7fff04_d099_489b_a972_ab8edd217441
{
    public class Class_StretchedPixelLine : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            PositionX = 2,
            PositionY = 3,
            Width = 4,
            Rotate = 5
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {

            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image = inputs[(int)InputId.Image].Eval(context).Image; // Needs to be checked for null!
            var PositionX = inputs[(int)InputId.PositionX].Eval(context).Value;
            var PositionY = inputs[(int)InputId.PositionY].Eval(context).Value;
            var Position = new Vector2(PositionX, PositionY);
            var Width = inputs[(int)InputId.Width].Eval(context).Value;
            var Rotate = inputs[(int)InputId.Rotate].Eval(context).Value;
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 1));

                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("Position").AsVector().Set(new Vector2(PositionX, PositionY));
                    _effect.GetVariableByName("Width").AsScalar().Set(Width);
                    _effect.GetVariableByName("Rotate").AsScalar().Set(Rotate);
                //<<< _setup


                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

