//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using Framefield.Core;

namespace Framefield.Core.ID30111eb0_0a25_4157_aa8d_b4b4302b19e4
{
    public class Class_StopWatch3 : OperatorPart.Function, Framefield.Core.OperatorPartTraits.ITimeAccessor
    {
        //>>> _inputids
        private enum InputId
        {
            Running = 0,
            ResetTrigger = 1
        }
        //<<< _inputids        

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Running = inputs[(int)InputId.Running].Eval(context).Value;
            var ResetTrigger = inputs[(int)InputId.ResetTrigger].Eval(context).Value;
            //<<< _params
            
            if (_lastTime == float.NaN)
            {
                _lastTime = context.Time;
            }
            if (_lastTime != context.Time)
            {
                _lastTime = context.Time;
                Changed = false;
            }
            
            bool resetTriggerUp = _oldResetTrigger < 0.5f && ResetTrigger > 0.5f;

            if(resetTriggerUp) {
                _duration= 0;
                _startTime = context.Time;
            }
                
            _oldResetTrigger = ResetTrigger;
                
            
            bool runningTriggerUp = _oldRunning < 0.5f && Running > 0.5f;
            bool runningTriggerDown = _oldRunning > 0.5f && Running < 0.5f;
            _oldRunning = Running;
            
            if (runningTriggerUp)
            {                
                _startTime = context.Time;
                _running = true;
            }
            else if(runningTriggerDown)
            {
                _running = false;
            }
            
            if(_running) {    
                _duration = context.Time - _startTime;
            }
            context.Value = _duration;

            return context;
        }

        bool _running = false;
        float _startTime=0;
        float _oldRunning;
        float _oldResetTrigger;
        float _lastTime = 0;
        float _duration = 0;
    }
}


