using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;

namespace Framefield.Core.ID2a153681_fe72_46d4_a1b6_7fbd2ea28909
{
    public class Class_Distribute : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            SceneInput = 0,
            TranslateX = 1,
            TranslateY = 2,
            TranslateZ = 3,
            RotateX = 4,
            RotateY = 5,
            RotateZ = 6,
            ScaleX = 7,
            ScaleY = 8,
            ScaleZ = 9
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var SceneInput = inputs[(int)InputId.SceneInput];
            var TranslateX = inputs[(int)InputId.TranslateX].Eval(context).Value;
            var TranslateY = inputs[(int)InputId.TranslateY].Eval(context).Value;
            var TranslateZ = inputs[(int)InputId.TranslateZ].Eval(context).Value;
            var Translate = new Vector3(TranslateX, TranslateY, TranslateZ);
            var RotateX = inputs[(int)InputId.RotateX].Eval(context).Value;
            var RotateY = inputs[(int)InputId.RotateY].Eval(context).Value;
            var RotateZ = inputs[(int)InputId.RotateZ].Eval(context).Value;
            var Rotate = new Vector3(RotateX, RotateY, RotateZ);
            var ScaleX = inputs[(int)InputId.ScaleX].Eval(context).Value;
            var ScaleY = inputs[(int)InputId.ScaleY].Eval(context).Value;
            var ScaleZ = inputs[(int)InputId.ScaleZ].Eval(context).Value;
            var Scale = new Vector3(ScaleX, ScaleY, ScaleZ);
            //<<< _params

            var translation = new Vector3(TranslateX, TranslateY, TranslateZ);
            var rotation = Quaternion.RotationYawPitchRoll(RotateX / 360.0f * (float)(2.0 * Math.PI),
                                                           RotateY / 360.0f * (float)(2.0 * Math.PI),
                                                           RotateZ / 360.0f * (float)(2.0 * Math.PI));
            var scale = new Vector3(ScaleX, ScaleY, ScaleZ);
            
            var prevTransform = context.ObjectTWorld;
            
            var centerMatrix = Matrix.Identity;
            Matrix.Translation( - Translate.X * (SceneInput.Connections.Count - 1) / 2.0f,
                                - Translate.Y * (SceneInput.Connections.Count - 1) / 2.0f,
                                - Translate.Z * (SceneInput.Connections.Count - 1) / 2.0f,
                                out centerMatrix);
            
            var transform = Matrix.Transformation(new Vector3(), new Quaternion(), scale, new Vector3(), rotation, translation);
            context.ObjectTWorld *=  centerMatrix;
            
            for (var i = 0; i < SceneInput.Connections.Count; ++i) 
            {
                SceneInput.Connections[i % SceneInput.Connections.Count].Eval(context);   
                context.ObjectTWorld = transform * context.ObjectTWorld;
            }
            
            context.ObjectTWorld = prevTransform;
            
            //!!automatic generated code starts here
            return context;
        }
    }
}

