//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID1fcee65b_9454_4c5a_9dc5_77bbab7dc9d4
{
    public class Class_Sky : FXImageFunction
    {
    
        protected override ViewportF GetViewport(OperatorPartContext context)
        {
            return _viewport;
        }
    
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Radius = 1,
            Feather = 2,
            CenterX = 3,
            CenterY = 4,
            StretchX = 5,
            StretchY = 6,
            InsideR = 7,
            InsideG = 8,
            InsideB = 9,
            InsideA = 10,
            OutsideR = 11,
            OutsideG = 12,
            OutsideB = 13,
            OutsideA = 14,
            IrisSides = 15,
            IrisRotate = 16,
            IrisShapeStrength = 17,
            IrisShapeWarp = 18,
            GradientBias = 19,
            ResolutionWidth = 20,
            ResolutionHeight = 21,
            SunVectorX = 22,
            SunVectorY = 23,
            GroundColorR = 24,
            GroundColorG = 25,
            GroundColorB = 26,
            GroundColorA = 27,
            horizonBlur = 28,
            horizonOffset = 29
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Radius = inputs[(int)InputId.Radius].Eval(context).Value;
            var Feather = inputs[(int)InputId.Feather].Eval(context).Value;
            var CenterX = inputs[(int)InputId.CenterX].Eval(context).Value;
            var CenterY = inputs[(int)InputId.CenterY].Eval(context).Value;
            var Center = new Vector2(CenterX, CenterY);
            var StretchX = inputs[(int)InputId.StretchX].Eval(context).Value;
            var StretchY = inputs[(int)InputId.StretchY].Eval(context).Value;
            var Stretch = new Vector2(StretchX, StretchY);
            var InsideR = inputs[(int)InputId.InsideR].Eval(context).Value;
            var InsideG = inputs[(int)InputId.InsideG].Eval(context).Value;
            var InsideB = inputs[(int)InputId.InsideB].Eval(context).Value;
            var InsideA = inputs[(int)InputId.InsideA].Eval(context).Value;
            var Inside = new Color4(InsideR, InsideG, InsideB, InsideA);
            var OutsideR = inputs[(int)InputId.OutsideR].Eval(context).Value;
            var OutsideG = inputs[(int)InputId.OutsideG].Eval(context).Value;
            var OutsideB = inputs[(int)InputId.OutsideB].Eval(context).Value;
            var OutsideA = inputs[(int)InputId.OutsideA].Eval(context).Value;
            var Outside = new Color4(OutsideR, OutsideG, OutsideB, OutsideA);
            var IrisSides = inputs[(int)InputId.IrisSides].Eval(context).Value;
            var IrisRotate = inputs[(int)InputId.IrisRotate].Eval(context).Value;
            var Iris = new Vector2(IrisSides, IrisRotate);
            var IrisShapeStrength = inputs[(int)InputId.IrisShapeStrength].Eval(context).Value;
            var IrisShapeWarp = inputs[(int)InputId.IrisShapeWarp].Eval(context).Value;
            var IrisShape = new Vector2(IrisShapeStrength, IrisShapeWarp);
            var GradientBias = inputs[(int)InputId.GradientBias].Eval(context).Value;
            var ResolutionWidth = inputs[(int)InputId.ResolutionWidth].Eval(context).Value;
            var ResolutionHeight = inputs[(int)InputId.ResolutionHeight].Eval(context).Value;
            var Resolution = new Vector2(ResolutionWidth, ResolutionHeight);
            var SunVectorX = inputs[(int)InputId.SunVectorX].Eval(context).Value;
            var SunVectorY = inputs[(int)InputId.SunVectorY].Eval(context).Value;
            var SunVector = new Vector2(SunVectorX, SunVectorY);
            var GroundColorR = inputs[(int)InputId.GroundColorR].Eval(context).Value;
            var GroundColorG = inputs[(int)InputId.GroundColorG].Eval(context).Value;
            var GroundColorB = inputs[(int)InputId.GroundColorB].Eval(context).Value;
            var GroundColorA = inputs[(int)InputId.GroundColorA].Eval(context).Value;
            var GroundColor = new Color4(GroundColorR, GroundColorG, GroundColorB, GroundColorA);
            var horizonBlur = inputs[(int)InputId.horizonBlur].Eval(context).Value;
            var horizonOffset = inputs[(int)InputId.horizonOffset].Eval(context).Value;
            //<<< _params
            
            //var oldViewport = context.Viewport;
            if( (int)ResolutionWidth >= 1 && (int)ResolutionHeight >= 1) {                                
                _viewport = new ViewportF( 0,0, ResolutionWidth, ResolutionHeight);
            }
            else {
                _viewport = context.Viewport;
            }
            
            return PrepareAndEvalOnChange(context, () => {
            
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));
                

                //>>> _setup
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Radius").AsScalar().Set(Radius);
                    _effect.GetVariableByName("Feather").AsScalar().Set(Feather);
                    _effect.GetVariableByName("Center").AsVector().Set(new Vector2(CenterX, CenterY));
                    _effect.GetVariableByName("Stretch").AsVector().Set(new Vector2(StretchX, StretchY));
                    _effect.GetVariableByName("Inside").AsVector().Set(new Vector4(InsideR, InsideG, InsideB, InsideA));
                    _effect.GetVariableByName("Outside").AsVector().Set(new Vector4(OutsideR, OutsideG, OutsideB, OutsideA));
                    _effect.GetVariableByName("Iris").AsVector().Set(new Vector2(IrisSides, IrisRotate));
                    _effect.GetVariableByName("IrisShape").AsVector().Set(new Vector2(IrisShapeStrength, IrisShapeWarp));
                    _effect.GetVariableByName("GradientBias").AsScalar().Set(GradientBias);
                    _effect.GetVariableByName("Resolution").AsVector().Set(new Vector2(ResolutionWidth, ResolutionHeight));
                    _effect.GetVariableByName("SunVector").AsVector().Set(new Vector2(SunVectorX, SunVectorY));
                    _effect.GetVariableByName("GroundColor").AsVector().Set(new Vector4(GroundColorR, GroundColorG, GroundColorB, GroundColorA));
                    _effect.GetVariableByName("horizonBlur").AsScalar().Set(horizonBlur);
                    _effect.GetVariableByName("horizonOffset").AsScalar().Set(horizonOffset);
                //<<< _setup
                
                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
            

        }
        
        private ViewportF _viewport;

    }
}



