//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID713a57fa_e05a_49f2_9f4a_cc3d49ca02f5
{
    public class Class_SineLinesWaves : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            iTime = 1,
            lineColorR = 2,
            lineColorG = 3,
            lineColorB = 4,
            lineColorA = 5
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var iTime = inputs[(int)InputId.iTime].Eval(context).Value;
            var lineColorR = inputs[(int)InputId.lineColorR].Eval(context).Value;
            var lineColorG = inputs[(int)InputId.lineColorG].Eval(context).Value;
            var lineColorB = inputs[(int)InputId.lineColorB].Eval(context).Value;
            var lineColorA = inputs[(int)InputId.lineColorA].Eval(context).Value;
            var lineColor = new Color4(lineColorR, lineColorG, lineColorB, lineColorA);
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("iTime").AsScalar().Set(iTime);
                    _effect.GetVariableByName("lineColor").AsVector().Set(new Vector4(lineColorR, lineColorG, lineColorB, lineColorA));
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}



