//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID9e778acf_cced_4d1d_888d_0a3ba085e1fe
{
    public class Class_SinSum3 : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            t = 0,
            PeriodX = 1,
            PeriodY = 2,
            PeriodZ = 3,
            PhaseX = 4,
            PhaseY = 5,
            PhaseZ = 6,
            AmplitudeX = 7,
            AmplitudeY = 8,
            AmplitudeZ = 9,
            Displace = 10,
            Offset = 11
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            //>>> _params
            var t = inputs[(int)InputId.t].Eval(context).Value;
            var PeriodX = inputs[(int)InputId.PeriodX].Eval(context).Value;
            var PeriodY = inputs[(int)InputId.PeriodY].Eval(context).Value;
            var PeriodZ = inputs[(int)InputId.PeriodZ].Eval(context).Value;
            var Period = new Vector3(PeriodX, PeriodY, PeriodZ);
            var PhaseX = inputs[(int)InputId.PhaseX].Eval(context).Value;
            var PhaseY = inputs[(int)InputId.PhaseY].Eval(context).Value;
            var PhaseZ = inputs[(int)InputId.PhaseZ].Eval(context).Value;
            var Phase = new Vector3(PhaseX, PhaseY, PhaseZ);
            var AmplitudeX = inputs[(int)InputId.AmplitudeX].Eval(context).Value;
            var AmplitudeY = inputs[(int)InputId.AmplitudeY].Eval(context).Value;
            var AmplitudeZ = inputs[(int)InputId.AmplitudeZ].Eval(context).Value;
            var Amplitude = new Vector3(AmplitudeX, AmplitudeY, AmplitudeZ);
            var Displace = inputs[(int)InputId.Displace].Eval(context).Value;
            var Offset = inputs[(int)InputId.Offset].Eval(context).Value;
            //<<< _params
            
            double d2r = Math.PI / 180.0; 
           
           double tx = 0; double ty = 0; double tz = 0;
           if ( Math.Abs(PeriodX) > 1e-6 ) tx = (2.0 * Math.PI) / PeriodX;
           if ( Math.Abs(PeriodY) > 1e-6 ) ty = (2.0 * Math.PI) / PeriodY;
           if ( Math.Abs(PeriodZ) > 1e-6 ) tz = (2.0 * Math.PI) / PeriodZ;
           
           
            context.Value = (float) Offset + (float)Displace * (float)( 
              Math.Sin( t * tx + PhaseX * d2r) * AmplitudeX
            + Math.Sin( t * ty + PhaseY * d2r) * AmplitudeY
            + Math.Sin( t * tz + PhaseZ * d2r) * AmplitudeZ
);
            
            return context;
        }
    }
}

