using System.Collections.Generic;
using SharpDX;
using Framefield.Core.OperatorPartTraits;
using System;

namespace Framefield.Core.ID51d5d2c1_f2bb_42d4_9a04_6349cb43b6b9
{
    public class Class_SimpleIK : OperatorPart.Function, ISceneTransform
    {
        // ISceneTransform
        public Matrix Transform
        {
            get
            {
                //UpdateTransform(new OperatorPartContext(), OperatorPart.Connections);
                return _transform;
            }
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            //var SceneInput = inputs[0];

            if (!Changed)
                return context;
                
            // >>> _params
            var PositionX = inputs[(int)InputId.PositionX].Eval(context).Value;
            var PositionY = inputs[(int)InputId.PositionY].Eval(context).Value;
            var PositionZ = inputs[(int)InputId.PositionZ].Eval(context).Value;
            var Position = new Vector3(PositionX, PositionY, PositionZ);
            var Rotate = inputs[(int)InputId.Rotate].Eval(context).Value;
            var LengthA = inputs[(int)InputId.LengthA].Eval(context).Value;
            var LengthB = inputs[(int)InputId.LengthB].Eval(context).Value;
            var Length = new Vector2(LengthA, LengthB);
            var SceneA = inputs[(int)InputId.SceneA];
            var SceneB = inputs[(int)InputId.SceneB];
            // <<< _params

            Vector3 scale, position;
            Quaternion rotation;
            context.ObjectTWorld.Decompose(out scale, out rotation, out position);

            var transform = GetLookAtMatrix( Vector3.Zero, Position);
            _transform = transform;


            
            
            //UpdateTransform(context, inputs);
            var prevTransform = context.ObjectTWorld;

            context.ObjectTWorld = _transform * prevTransform;
            SceneA.Eval(context);
            //context.ObjectTWorld = prevTransform;


            var moveB = Matrix.Translation( new Vector3(1,0,0));
            
            //var t2= 
            
            //context.ObjectTWorld = GetLookAtMatrix( Position )  * moveB;            
            
            SceneA.Eval(context);
            context.ObjectTWorld = prevTransform;


            return context;
        }
        
        // >>> _inputids
        private enum InputId
        {
            PositionX = 0,
            PositionY = 1,
            PositionZ = 2,
            Rotate = 3,
            LengthA = 4,
            LengthB = 5,
            SceneA = 6,
            SceneB = 7
        }
        // <<< _inputids

        Matrix GetLookAtMatrix( Vector3 position, Vector3 target) {
            var transform = Matrix.Identity;
            var t = position - target;
            if (t.Length() > 0)
            {
                var dir = -t;
                dir.Normalize();
                var helperDir = new Vector3(0, 1, 0);
                //if (Math.Abs(dir.Y) < 0.1 && Math.Abs(dir.Z) < 0.1)
                //    helperDir = new Vector3(1, 0, 1);
                    
                var xAxis = Vector3.Cross(dir, helperDir);                
                xAxis.Normalize();
                
                var yAxis = Vector3.Cross(xAxis, dir);
                yAxis.Normalize();
                
                var m = Matrix.Identity;
                m.Row1 = new Vector4(yAxis, 0);
                m.Row2 = new Vector4(xAxis, 0);
                m.Row3 = new Vector4(dir, 0);
                transform *= m;
            }
            return transform;
        }
        
        

        private Matrix _transform;
    }
}
