using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.DXGI;

namespace Framefield.Core.ID91a11db9_7e51_45bd_b352_40929020675f
{
    public class Class_ScaleResolution : OperatorPart.Function
    {
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            var Scene = inputs[2];

            int DivX = (int) inputs[0].Eval(context).Value;
            int DivY = (int) inputs[1].Eval(context).Value;

            var oldViewport = context.Viewport;
            context.Viewport = new ViewportF(0, 0, oldViewport.Width/DivX, oldViewport.Height/DivY);
            Logger.Info(this, "Scale Viewport from {0}/{1} to {2}/{3}.", oldViewport.Width, oldViewport.Height, context.Viewport.Width, context.Viewport.Height);
            Scene.Eval(context);
            context.Viewport = oldViewport;

            return context;
        }

    }
}

