//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID44592105_1be1_4900_8ff6_8dbd8fca9392
{
    public class Class_SampleAndBlurValue : OperatorPart.Function, 
        Framefield.Core.OperatorPartTraits.ITimeAccessor
    {
        //>>> _inputids
        private enum InputId
        {
            AnimatedValue = 0,
            TimeRangeStart = 1,
            TimeRangeEnd = 2,
            TimeResolution = 3,
            ResampleTrigger = 4,
            SmoothSamples = 5
        }
        //<<< _inputids
        
        

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var AnimatedValue = inputs[(int)InputId.AnimatedValue].Eval(context).Value;
            var TimeRangeStart = inputs[(int)InputId.TimeRangeStart].Eval(context).Value;
            var TimeRangeEnd = inputs[(int)InputId.TimeRangeEnd].Eval(context).Value;
            var TimeRange = new Vector2(TimeRangeStart, TimeRangeEnd);
            var TimeResolution = inputs[(int)InputId.TimeResolution].Eval(context).Value;
            var ResampleTrigger = inputs[(int)InputId.ResampleTrigger].Eval(context).Value;
            var SmoothSamples = inputs[(int)InputId.SmoothSamples].Eval(context).Value;
            //<<< _params
            
            
            if(Changed) 
            {
                int smoothSamplesClamped = (int)Utilities.Clamp( SmoothSamples, 1, 10);
            
                var needsResampling =  (TimeRangeStart != _startTime)
                                    || (TimeRangeEnd != _endTime)
                                    || (TimeResolution != _timeResolution)
                                    || (smoothSamplesClamped != _smoothSamples)
                                    || ResampleTrigger > 0.5f;
                
                if( needsResampling) 
                {
                    _startTime = TimeRangeStart;
                    _endTime = TimeRangeEnd;
                    _timeResolution = TimeResolution;
                    _smoothSamples = smoothSamplesClamped;

                    UpdateSampleCount();
                    Logger.Info("Resample " + _sampleCount + "samples");
                    
                    
                    var valueInput = inputs[(int)InputId.AnimatedValue];                    
                    SampleValueRange(valueInput,  context);
                    
                    
                    SmoothBuffer( ref _bufferA, ref _bufferB, _smoothSamples, 1);
                    SmoothBuffer( ref _bufferB, ref _bufferA, _smoothSamples, 2);
                    //SmoothBuffer( ref _bufferB, ref _bufferA, _smoothSamples , 2);
                    //SmoothBuffer( ref _bufferA, ref _bufferB, _smoothSamples , 4);
                    //SmoothBuffer( ref _bufferB, ref _bufferA, _smoothSamples , 8);                    
                }

                Changed =false;
            }
            //Logger.Info("" +context.Time);
            
            var sampleIndex = (int)Utilities.Clamp( (context.Time - _startTime) * TimeResolution, 0, _sampleCount-1);
            context.Value = _bufferA[sampleIndex];
            return context;
        }
        

        
        
        private void UpdateSampleCount() 
        {
            _sampleCount = (int) Utilities.Clamp( (_endTime - _startTime) * _timeResolution, 2, MAX_SAMPLE_STEPS);
            if( _bufferA == null ||  _bufferA.Length != _sampleCount) 
            {
                _bufferA = new float[_sampleCount];
                _bufferB = new float[_sampleCount];
            }        
        }


        private void SampleValueRange(OperatorPart valueInput, OperatorPartContext context) 
        {
            var previousTime = context.Time;

            OperatorPart.ChangedPropagationEnabled = false;
            
            var invalidator = new OperatorPart.InvalidateTimeAccessors();
            
            for (var i = 0; i < _sampleCount - 1; i++)
            {   
                var f = i/(float)_sampleCount;
                var t = Utilities.Lerp(_startTime, _endTime, f);                 
                context.Time = t;
                _bufferA[i] = valueInput.Eval(context).Value;

                // Invalidate all time accessors
                valueInput.TraverseWithFunction(null, invalidator);                                        
            }
            
            OperatorPart.ChangedPropagationEnabled = true;
            context.Time = previousTime;            
            valueInput.TraverseWithFunction(null, invalidator);          
        }
        
        
        
        private void SmoothBuffer(ref float[] inBuffer, ref float[] outBuffer, int sampleCount, int stepWidth =1) 
        {
            for(var i = 0; i < inBuffer.Length; i++ ) 
            {
                var average =0f;
                var count = 0f;
                
                for(var ds = 0 ; ds < sampleCount; ds++ ) 
                {
                    var smoothI = i + (-sampleCount / 2 + ds) * stepWidth  ;
                    
                    if(smoothI < 0 || smoothI >= inBuffer.Length)
                        continue;
                        
                    average+= inBuffer[smoothI];
                    count ++;
                }
                outBuffer[i] = average/count;                    
            }
        }
        
        private float _startTime;
        private float _endTime;
        private float _timeResolution;
        private const int MAX_SAMPLE_STEPS = 100000;
        private int _sampleCount= 1;
        private int _smoothSamples = 2;
        
        private float[] _bufferA;
        private float[] _bufferB;
        //private float _targetValue = 0;
        //private float _sum = 0;
        //private SmoothInterpolator _smoothInterpolator = new SmoothInterpolator(defaultValue:0, acceleration:0.4, delta:0.001);
    }
}

