//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDfd8e7a29_0d14_4e41_ab8b_6866fcdbf775
{
    public class Class_RoundedRect : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Radius = 1,
            Feather = 2,
            CenterX = 3,
            CenterY = 4,
            ScaleX = 5,
            ScaleY = 6,
            InsideR = 7,
            InsideG = 8,
            InsideB = 9,
            InsideA = 10,
            OutsideR = 11,
            OutsideG = 12,
            OutsideB = 13,
            OutsideA = 14,
            IrisSides = 15,
            IrisRotate = 16,
            IrisShapeStrength = 17,
            IrisShapeWarp = 18
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Radius = inputs[(int)InputId.Radius].Eval(context).Value;
            var Feather = inputs[(int)InputId.Feather].Eval(context).Value;
            var CenterX = inputs[(int)InputId.CenterX].Eval(context).Value;
            var CenterY = inputs[(int)InputId.CenterY].Eval(context).Value;
            var Center = new Vector2(CenterX, CenterY);
            var ScaleX = inputs[(int)InputId.ScaleX].Eval(context).Value;
            var ScaleY = inputs[(int)InputId.ScaleY].Eval(context).Value;
            var Scale = new Vector2(ScaleX, ScaleY);
            var InsideR = inputs[(int)InputId.InsideR].Eval(context).Value;
            var InsideG = inputs[(int)InputId.InsideG].Eval(context).Value;
            var InsideB = inputs[(int)InputId.InsideB].Eval(context).Value;
            var InsideA = inputs[(int)InputId.InsideA].Eval(context).Value;
            var Inside = new Color4(InsideR, InsideG, InsideB, InsideA);
            var OutsideR = inputs[(int)InputId.OutsideR].Eval(context).Value;
            var OutsideG = inputs[(int)InputId.OutsideG].Eval(context).Value;
            var OutsideB = inputs[(int)InputId.OutsideB].Eval(context).Value;
            var OutsideA = inputs[(int)InputId.OutsideA].Eval(context).Value;
            var Outside = new Color4(OutsideR, OutsideG, OutsideB, OutsideA);
            var IrisSides = inputs[(int)InputId.IrisSides].Eval(context).Value;
            var IrisRotate = inputs[(int)InputId.IrisRotate].Eval(context).Value;
            var Iris = new Vector2(IrisSides, IrisRotate);
            var IrisShapeStrength = inputs[(int)InputId.IrisShapeStrength].Eval(context).Value;
            var IrisShapeWarp = inputs[(int)InputId.IrisShapeWarp].Eval(context).Value;
            var IrisShape = new Vector2(IrisShapeStrength, IrisShapeWarp);
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Radius").AsScalar().Set(Radius);
                    _effect.GetVariableByName("Feather").AsScalar().Set(Feather);
                    _effect.GetVariableByName("Center").AsVector().Set(new Vector2(CenterX, CenterY));
                    _effect.GetVariableByName("Scale").AsVector().Set(new Vector2(ScaleX, ScaleY));
                    _effect.GetVariableByName("Inside").AsVector().Set(new Vector4(InsideR, InsideG, InsideB, InsideA));
                    _effect.GetVariableByName("Outside").AsVector().Set(new Vector4(OutsideR, OutsideG, OutsideB, OutsideA));
                    _effect.GetVariableByName("Iris").AsVector().Set(new Vector2(IrisSides, IrisRotate));
                    _effect.GetVariableByName("IrisShape").AsVector().Set(new Vector2(IrisShapeStrength, IrisShapeWarp));
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}



