//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using Framefield.Core.Rendering;

namespace Framefield.Core.ID1c5514cd_799d_46c1_ac4a_bac2f933b816
{
    public class Class_ReflectivePhongShader : FXSourceCodeFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Scene = 1,
            Refraction = 2,
            FallOff = 3,
            ReflectionColorR = 4,
            ReflectionColorG = 5,
            ReflectionColorB = 6,
            ReflectionColorA = 7,
            BlendFactorR = 8,
            BlendFactorG = 9,
            BlendFactorB = 10,
            BlendFactorA = 11
        }
        //<<< _inputids

        #region Renderer
        public class Renderer : BaseRenderer
        {
            public override void SetupEffect(OperatorPartContext context)
            {
                base.SetupEffect(context);
                try
                {
                    SetupMaterialConstBuffer(context);
                    SetupFogSettingsConstBuffer(context);
                    SetupPointLightsConstBuffer(context);
                }
                catch (Exception e)
                {
                    Logger.Error(ParentFunc, "Error building constant buffer: {0} - Source: {1}", e.Message, e.Source);
                }
            }
            public OperatorPart.Function ParentFunc {get;set;}
        }
        #endregion

        public Class_ReflectivePhongShader()
        {
            _renderer = new Renderer(){ParentFunc = this};
        }

        public override void Dispose()
        {
            Utilities.DisposeObj(ref _renderer);
            base.Dispose();
        }

        bool _firstEval = true;
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Scene = inputs[(int)InputId.Scene];
            var Refraction = inputs[(int)InputId.Refraction].Eval(context).Value;
            var FallOff = inputs[(int)InputId.FallOff].Eval(context).Value;
            var ReflectionColorR = inputs[(int)InputId.ReflectionColorR].Eval(context).Value;
            var ReflectionColorG = inputs[(int)InputId.ReflectionColorG].Eval(context).Value;
            var ReflectionColorB = inputs[(int)InputId.ReflectionColorB].Eval(context).Value;
            var ReflectionColorA = inputs[(int)InputId.ReflectionColorA].Eval(context).Value;
            var ReflectionColor = new Color4(ReflectionColorR, ReflectionColorG, ReflectionColorB, ReflectionColorA);
            var BlendFactorR = inputs[(int)InputId.BlendFactorR].Eval(context).Value;
            var BlendFactorG = inputs[(int)InputId.BlendFactorG].Eval(context).Value;
            var BlendFactorB = inputs[(int)InputId.BlendFactorB].Eval(context).Value;
            var BlendFactorA = inputs[(int)InputId.BlendFactorA].Eval(context).Value;
            var BlendFactor = new Color4(BlendFactorR, BlendFactorG, BlendFactorB, BlendFactorA);
            //<<< _params

            if (_firstEval)
            {
                for (int i = 0; i < NumCodes(); ++i)
                    Compile(i);
                _firstEval = false;
                Changed = true;
            }

            using (new PropertyStasher<OperatorPartContext>(context, "Effect", "Renderer"))
            {
                _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(context.Viewport.Width, context.Viewport.Height));
                _effect.GetVariableByName("Refraction").AsScalar().Set(Refraction);
                _effect.GetVariableByName("FallOff").AsScalar().Set(FallOff);
                _effect.GetVariableByName("ReflectionColor").AsVector().Set(new Vector4(ReflectionColorR, ReflectionColorG, ReflectionColorB, ReflectionColorA));
                _effect.GetVariableByName("BlendFactor").AsVector().Set(new Vector4(BlendFactorR, BlendFactorG, BlendFactorB, BlendFactorA));
                //_effect.GetVariableByName("BlendFactor").AsScalar().Set(BlendFactor);
                context.Effect = _effect;
                context.Renderer = _renderer;

                Scene.Eval(context);
            }

            return context;
        }

        Renderer _renderer;
    }
}


