//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID3ed47ad6_e6e7_423f_811b_bfa03aa3b71c
{
    public class Class_RasterizerState : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            SceneInput = 0,
            FillMode = 1,
            CullMode = 2,
            FrontCounterClockwise = 3,
            DepthBias = 4,
            DepthBiasClamp = 5,
            SlopeScaledDepthBias = 6,
            DepthClipEnable = 7,
            ScissorEnable = 8,
            MultisampleEnable = 9,
            AntialiasedLineEnable = 10
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var SceneInput = inputs[(int)InputId.SceneInput];
            var FillMode = (int) inputs[(int)InputId.FillMode].Eval(context).Value;
            var CullMode = (int) inputs[(int)InputId.CullMode].Eval(context).Value;
            var FrontCounterClockwise = (int) inputs[(int)InputId.FrontCounterClockwise].Eval(context).Value;
            var DepthBias = inputs[(int)InputId.DepthBias].Eval(context).Value;
            var DepthBiasClamp = inputs[(int)InputId.DepthBiasClamp].Eval(context).Value;
            var SlopeScaledDepthBias = inputs[(int)InputId.SlopeScaledDepthBias].Eval(context).Value;
            var DepthClipEnable = (int) inputs[(int)InputId.DepthClipEnable].Eval(context).Value;
            var ScissorEnable = (int) inputs[(int)InputId.ScissorEnable].Eval(context).Value;
            var MultisampleEnable = (int) inputs[(int)InputId.MultisampleEnable].Eval(context).Value;
            var AntialiasedLineEnable = (int) inputs[(int)InputId.AntialiasedLineEnable].Eval(context).Value;
            //<<< _params

            if (Changed)
            {
                var rasterizerDescription = new RasterizerStateDescription();
                rasterizerDescription.FillMode = (FillMode) FillMode;
                rasterizerDescription.CullMode = (CullMode) CullMode;
                rasterizerDescription.IsFrontCounterClockwise = FrontCounterClockwise == 1.0 ? true : false;
                rasterizerDescription.DepthBias = (int) DepthBias;
                rasterizerDescription.DepthBiasClamp = DepthBiasClamp;
                rasterizerDescription.SlopeScaledDepthBias = SlopeScaledDepthBias;
                rasterizerDescription.IsDepthClipEnabled = DepthClipEnable == 1.0 ? true : false;
                rasterizerDescription.IsScissorEnabled = ScissorEnable == 1.0 ? true : false;
                rasterizerDescription.IsMultisampleEnabled = MultisampleEnable == 1.0 ? true : false;
                rasterizerDescription.IsAntialiasedLineEnabled = AntialiasedLineEnable == 1.0 ? true : false;

                Utilities.DisposeObj(ref _rasterizerState);
                _rasterizerState = new RasterizerState(context.D3DDevice, rasterizerDescription);
                Changed = false;
            }

            var prevRasterizerState = context.RasterizerState;
            context.RasterizerState = _rasterizerState;
            SceneInput.Eval(context);
            context.RasterizerState = prevRasterizerState;

            return context;
        }

        private RasterizerState _rasterizerState = null;
    }
}

