//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDba00c124_5824_4797_abfc_1d9ac1ab2d52
{
    public class Class_Pulsate : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            BeatTime = 0,
            Frequency = 1,
            Intensity = 2
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            //>>> _params
            var BeatTime = inputs[(int)InputId.BeatTime].Eval(context).Value;
            var Frequency = inputs[(int)InputId.Frequency].Eval(context).Value;
            var Intensity = inputs[(int)InputId.Intensity].Eval(context).Value;
            //<<< _params
            
            //const float Steps = 6+1;
            
            float v = 0;
            // Off
            if( Frequency == 0) {
               v=0;
            }
            //else if( Frequency < 0.1 ) {
            //    v = 1 - (BeatTime / 16) % 1;
            //}
            else if( Frequency < 0.3 ) {
                v = 1 - (BeatTime / 4f) % 1;
            }
            else if( Frequency < 0.7) {
                v = 1 - (BeatTime) % 1;            
            }
            else if( Frequency < 0.90) {
                v = 1 - (BeatTime * 4) % 1;            
            }
            else {
                v = 1 - (BeatTime * 16) % 1;            
            }
            
            context.Value = v * Intensity;
            
            return context;
        }
    }
}

