//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDaa378e2c_a832_4b81_bcf0_576aa285b3f5
{
    public class Class_PlasmaDisplace : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            AmpX = 2,
            AmpY = 3,
            Time = 4,
            PeriodX = 5,
            PeriodY = 6
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image = inputs[(int)InputId.Image].Eval(context).Image; // Needs to be checked for null!
            var AmpX = inputs[(int)InputId.AmpX].Eval(context).Value;
            var AmpY = inputs[(int)InputId.AmpY].Eval(context).Value;
            var Amp = new Vector2(AmpX, AmpY);
            var Time = inputs[(int)InputId.Time].Eval(context).Value;
            var PeriodX = inputs[(int)InputId.PeriodX].Eval(context).Value;
            var PeriodY = inputs[(int)InputId.PeriodY].Eval(context).Value;
            var Period = new Vector2(PeriodX, PeriodY);
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 1));

                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("Amp").AsVector().Set(new Vector2(AmpX, AmpY));
                    _effect.GetVariableByName("Time").AsScalar().Set(Time);
                    _effect.GetVariableByName("Period").AsVector().Set(new Vector2(PeriodX, PeriodY));
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

