//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID61383656_2268_46b8_b785_1b803c8b8681
{
    public class Class_OverrideTime : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            Input = 0,
            Time = 1
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params 
            var Input = inputs[(int)InputId.Input];
            var Time = inputs[(int)InputId.Time].Eval(context).Value;
            //<<< _params 

            var oldTime = context.Time;
            context.Time = Time;

            var invalidator = new OperatorPart.InvalidateTimeAccessors();
            Input.TraverseWithFunction(null, invalidator);
            Input.Eval(context);

            context.Time = oldTime;
            return context;
        }

    }
}


