using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;


namespace Framefield.Core.ID151abf24_7a6f_4f91_b3d0_e3216e75ec78
{
    public class Class_NthString : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            StringList = 0,
            Index = 1
        }
        //<<< _inputids



        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> params
            dynamic StringList = inputs[(int)InputId.StringList].Eval(context).Dynamic;
            int Index = (int) inputs[(int)InputId.Index].Eval(context).Value;
            //<<< params            
            if(StringList == null) {
                Logger.Info(this,"Can't convert incoming structure to Dynamic");
                return context;
            }
            
            if( Index >= 0 && Index < StringList.Count) {
                context.Text= StringList[Index];
            }
            else  {
                context.Text = "";
            }
            //Logger.Info(this,"{0}", context.Text);
            
            return context;
        }
    }
}

