using System;
using System.Collections.Generic;
using SharpDX.Direct3D11;
using Framefield.Core.Rendering;

namespace Framefield.Core.IDfa83d4dd_4371_4df9_9876_6807d0ee0bdc
{
    public class Class_NormalMapper : FXSourceCodeFunction, IFXSceneSourceCode
    {
        #region Renderer
        public class Renderer : BaseRenderer
        {
            public override void Dispose() {
                Utilities.DisposeObj(ref _normalMap);
                base.Dispose();
            }

            public ShaderResourceView NormalMap
            {
                set {
                    Dispose();
                    _normalMap = value;
                }
            }

            public override void SetupEffect(OperatorPartContext context) {
                base.SetupEffect(context);
                var resourceVariable = context.Effect.GetVariableByName("txNormalMap").AsShaderResource();
                resourceVariable.SetResource(_normalMap);

                try
                {
                    SetupMaterialConstBuffer(context);
                    SetupFogSettingsConstBuffer(context);
                    SetupPointLightsConstBuffer(context);
                }
                catch (Exception e) {
                    Logger.Error(ParentFunc, "Error building constant buffer: {0} - Source: {1}", e.Message, e.Source);
                }
            }
            public OperatorPart.Function ParentFunc {get;set;}
            private ShaderResourceView _normalMap;
        }
        #endregion

        public Class_NormalMapper() {
            _renderer = new Renderer(){ParentFunc = this};
        }

        public override void Dispose() {
            Utilities.DisposeObj(ref _renderer);
            Utilities.DisposeObj(ref _image);
            base.Dispose();
        }

        bool _firstEval = true;
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            if (_firstEval) {
                for (int i = 0; i < NumCodes(); ++i)
                    Compile(i);
                _firstEval = false;
                Changed = true;
            }

            var Scene = inputs[1];
            if (Changed) {
                Utilities.DisposeObj(ref _image);
                var image = inputs[2].Eval(context).Image;
                if (image != null)
                    _image = new ShaderResourceView(context.D3DDevice, image);

                var normalMap = inputs[3].Eval(context).Image;
                if (normalMap != null)
                    _renderer.NormalMap = new ShaderResourceView(context.D3DDevice, normalMap);
            }

            var D3DDevice = context.D3DDevice;

            using (new PropertyStasher<OperatorPartContext>(context, "Effect", "Renderer", "Texture0")) {
                context.Effect = _effect;
                context.Renderer = _renderer;
                context.Texture0 = _image;
    
                Scene.Eval(context);
            }

            return context;
        }

        Renderer _renderer;
        ShaderResourceView _image;
    }
}


