//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using Framefield.Core.OperatorPartTraits;
using Framefield.Core.Rendering;
using Buffer = SharpDX.Direct3D11.Buffer;
using SharpDX.Direct3D;

namespace Framefield.Core.IDc60cc037_2232_4c73_ab16_daf3549a078d
{
    public class Class_NoiseDistortShader3 : FXSourceCodeFunction, IFXSceneSourceCode, IMeshSupplier
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Scene = 1,
            RGBANoise = 2,
            NoiseOffsetX = 3,
            NoiseOffsetY = 4,
            NoiseOffsetZ = 5,
            NoiseAmount = 6,
            NoiseTime = 7,
            NoiseRepeat = 8,
            AmplifySurface = 9,
            FlatShadingFactor = 10
        }
        //<<< _inputids

        public Class_NoiseDistortShader3()
        {
            _meshCollector = new MeshCollector(this);
        }

        public override void Dispose() 
        {
            Utilities.DisposeObj(ref _mesh);
            base.Dispose();
        }

        public void AddMeshesTo(ICollection<Mesh> meshes)
        {
            UpdateMesh(new OperatorPartContext(), OperatorPart.Connections);
            if (_mesh != null)
                meshes.Add(_mesh);
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            try
            {
                UpdateMesh(context, inputs);

                if (_mesh.Vertices != null)
                {
                    // render stream output to screen or whatever target is set
                    context.Renderer.SetupEffect(context);
                    context.Renderer.Render(_mesh, context);
                }
            }
            catch (Exception exception)
            {
                Logger.Error(this, "Load Effect error: {0}", exception.Message);
            }

            return context;
        }

        bool _firstEval = true;
        private void UpdateMesh(OperatorPartContext context, List<OperatorPart> inputs)
        {
            if (_firstEval)
            {
                for (int i = 0; i < NumCodes(); ++i)
                    Compile(i);
                _firstEval = false;
                Changed = true;
            }

            if (!Changed && _mesh.Vertices != null)
                return;

            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Scene = inputs[(int)InputId.Scene];
            var RGBANoise = inputs[(int)InputId.RGBANoise].Eval(context).Image; // Needs to be checked for null!
            var NoiseOffsetX = inputs[(int)InputId.NoiseOffsetX].Eval(context).Value;
            var NoiseOffsetY = inputs[(int)InputId.NoiseOffsetY].Eval(context).Value;
            var NoiseOffsetZ = inputs[(int)InputId.NoiseOffsetZ].Eval(context).Value;
            var NoiseOffset = new Vector3(NoiseOffsetX, NoiseOffsetY, NoiseOffsetZ);
            var NoiseAmount = inputs[(int)InputId.NoiseAmount].Eval(context).Value;
            var NoiseTime = inputs[(int)InputId.NoiseTime].Eval(context).Value;
            var NoiseRepeat = inputs[(int)InputId.NoiseRepeat].Eval(context).Value;
            var AmplifySurface = inputs[(int)InputId.AmplifySurface].Eval(context).Value;
            var FlatShadingFactor = inputs[(int)InputId.FlatShadingFactor].Eval(context).Value;
            //<<< _params

            if (Scene.Func.Changed || _mesh.Vertices == null)
            {
                //Logger.Info(this, "collect meshes");
                _meshCollector.Collect(Scene);
                Scene.Func.Changed = false;
            }

            var inputMesh = _meshCollector.FirstMeshOrDefault;
            if (inputMesh == null)
                return;

            _mesh.AttributesSize = inputMesh.AttributesSize;
            _mesh.NumTriangles = inputMesh.NumTriangles;
            _mesh.InputElements = inputMesh.InputElements;
            if (_mesh.Vertices == null || _mesh.Vertices.Description.SizeInBytes != inputMesh.Vertices.Description.SizeInBytes)
            {
                if (_mesh.Vertices != null)
                    _mesh.Vertices.Dispose();

                _mesh.Vertices = new Buffer(D3DDevice.Device, new BufferDescription()
                                                                    {
                                                                        BindFlags = BindFlags.StreamOutput | BindFlags.VertexBuffer,
                                                                        CpuAccessFlags = CpuAccessFlags.None,
                                                                        OptionFlags = ResourceOptionFlags.None,
                                                                        SizeInBytes = _mesh.NumTriangles*inputMesh.AttributesSize*3,
                                                                        Usage = ResourceUsage.Default
                                                                    });
            }
            var noiseTextureView = new ShaderResourceView(context.D3DDevice, RGBANoise);
            _effect.GetVariableByName("RGBANoise").AsShaderResource().SetResource(noiseTextureView);
                        
            SetVector("NoiseOffset",NoiseOffset);
            SetScalar("NoiseAmount",NoiseAmount);
            SetScalar("NoiseTime", NoiseTime);
            SetScalar("AmplifySurface", AmplifySurface);
            SetScalar("FlatShadingFactor", FlatShadingFactor);
            NoiseRepeat = NoiseRepeat == 0 ? 100000f : 100f/NoiseRepeat;
                        
            SetScalar("NoiseRepeat", NoiseRepeat);            
            //_effect.GetVariableByName("UpVector").AsVector().Set(UpVector);
            context.D3DDevice.ImmediateContext.StreamOutput.SetTargets(new [] { new StreamOutputBufferBinding(_mesh.Vertices, 0) });
            context.D3DDevice.ImmediateContext.OutputMerger.DepthStencilState = new DepthStencilState(context.D3DDevice,
                                                                                                        new DepthStencilStateDescription()
                                                                                                            {
                                                                                                                IsDepthEnabled = false,
                                                                                                                IsStencilEnabled = false
                                                                                                            });
            context.D3DDevice.ImmediateContext.InputAssembler.InputLayout = context.InputLayout;
            context.D3DDevice.ImmediateContext.InputAssembler.PrimitiveTopology = PrimitiveTopology.TriangleList;
            context.D3DDevice.ImmediateContext.InputAssembler.SetVertexBuffers(0, new VertexBufferBinding(inputMesh.Vertices, inputMesh.AttributesSize, 0));
            var technique = _effect.GetTechniqueByIndex(0);
            technique.GetPassByIndex(0).Apply(context.D3DDevice.ImmediateContext);
            context.D3DDevice.ImmediateContext.Draw(_mesh.NumTriangles*3, 0);
            context.D3DDevice.ImmediateContext.StreamOutput.SetTargets(new [] { new StreamOutputBufferBinding(null, 0) });

            Changed = false;
        }

        private Mesh _mesh = new Mesh();
        private MeshCollector _meshCollector;
    }
}


