//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
using Framefield.Core.IDb03022e3_8b4f_4d33_b749_ef30a03ef098; // CurveProviderFunc
//<<< _using

namespace Framefield.Core.ID10e949fd_c7ab_4855_8490_db0d6fe5fb15
{
    public class Class_NoiseCurve : OperatorPart.Function, ICurveProvider
    {
        //>>> _inputids
        private enum InputId
        {
            U = 0,
            Resolution = 1,
            Count = 2
        }
        //<<< _inputids
        
        //>>> _outputids
        private enum OutputId
        {
            X = 0,
            Y = 1,
            Z = 2,
            This = 3
        }
        //<<< _outputids
        
        public List<Vector4> GetPoints() 
        {
            var r = new List<Vector4>();
            for(int i = 0; i < _count; i++ ){
                var p = Utilities.PerlinNoise3(i,1,4); // _controlPoints.ToList();
                r.Add( new Vector4(p.X, p.Y, p.Z, 1));
            }
            return r;
        }
        
        
        int _count;
        
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            //>>> _params
            var U = inputs[(int)InputId.U].Eval(context).Value;
            var Resolution = inputs[(int)InputId.Resolution].Eval(context).Value;
            var Count = inputs[(int)InputId.Count].Eval(context).Value;
            //<<< _params
                        
            var p = Utilities.PerlinNoise3(U);
            switch( (int) outputIdx) {
                case (int)OutputId.X: context.Value= p.X; break;
                case (int)OutputId.Y: context.Value= p.Y; break;
                case (int)OutputId.Z: context.Value= p.Z; break;
                case (int)OutputId.This: context.Dynamic= this; break;
            }
                   
            _count = (int)Count;                   
            return context;
        }

        public Vector4 SampleAt(double u) 
        {
            var p = Utilities.PerlinNoise3((float)u, 1, 2);
            //return new Vector4(p.X, p.Y, p.Z, 1);
            return new Vector4((float)u, p.Z, p.X, p.Y);
        }        
    }        
}

