//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using Framefield.Core;
using Framefield.Core.Inputs;


namespace Framefield.Core.ID16b377aa_c233_4d62_a63d_2f1f90d756c6
{
    public class Class_MouseInput : OperatorPart.Function, Framefield.Core.OperatorPartTraits.IAsyncDependend
    {
        public bool AsyncChanged { get { return _asyncChanged; } }

        //>>> _inputids
        private enum InputId
        {
            Output = 0,
            ResetTrigger = 1,
            ClampXMin = 2,
            ClampXMax = 3,
            ClampYMin = 4,
            ClampYMax = 5
        }
        //<<< _inputids 

        public Class_MouseInput()
        {
            Input.Mouse.MouseInputEvent += HandleMouseInputEvent;
        }
        public override void Dispose()
        {
            Input.Mouse.MouseInputEvent -= HandleMouseInputEvent;
        }

        void HandleMouseInputEvent(object o, MouseInput.MouseEventArgs e)
        {
            _lastEventArgs = e;
            _asyncChanged = true;

            if (e.ButtonFlags.HasFlag(MouseInput.ButtonFlags.MiddleButtonDown))
            {
                _dragX = 0;
                _dragY = 0;
            }
            if (e.ButtonFlags.HasFlag(MouseInput.ButtonFlags.LeftButtonDown))
            {
                _pressed = true;
            }
            if (e.ButtonFlags.HasFlag(MouseInput.ButtonFlags.LeftButtonUp))
            {
                _pressed = false;
            }
            
            if (_pressed)
            {
                _dragX += e.X;
                _dragY += e.Y;
            }

            _moveX = (int)Utilities.Clamp( _moveX + e.X, _clampXMin, _clampXMax);
            _moveY = (int)Utilities.Clamp( _moveY + e.Y, _clampYMin, _clampYMax);
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Output = (int) inputs[(int)InputId.Output].Eval(context).Value;
            var ResetTrigger = inputs[(int)InputId.ResetTrigger].Eval(context).Value;
            var ClampXMin = inputs[(int)InputId.ClampXMin].Eval(context).Value;
            var ClampXMax = inputs[(int)InputId.ClampXMax].Eval(context).Value;
            var ClampX = new Vector2(ClampXMin, ClampXMax);
            var ClampYMin = inputs[(int)InputId.ClampYMin].Eval(context).Value;
            var ClampYMax = inputs[(int)InputId.ClampYMax].Eval(context).Value;
            var ClampY = new Vector2(ClampYMin, ClampYMax);
            //<<< _params
            
            if (ResetTrigger > 0.5)
            {
                _moveX = 0;
                _moveY = 0;
            }
            
            _clampXMin = ClampXMin;
            _clampXMax = ClampXMax;
            _clampYMin = ClampYMin;
            _clampYMax = ClampYMax;

            _asyncChanged = false;

            if (_lastEventArgs == null)
            {
                context.Value = 0;
                return context;
            }

            switch (Output)
            {
                case 1: context.Value = _lastEventArgs.ButtonFlags.HasFlag(MouseInput.ButtonFlags.LeftButtonDown) ? 1 : 0; break;
                case 2: context.Value = _lastEventArgs.ButtonFlags.HasFlag(MouseInput.ButtonFlags.LeftButtonUp) ? 1 : 0; break;
                case 3: context.Value = _lastEventArgs.ButtonFlags.HasFlag(MouseInput.ButtonFlags.MiddleButtonDown) ? 1 : 0; break;
                case 4: context.Value = _lastEventArgs.ButtonFlags.HasFlag(MouseInput.ButtonFlags.MiddleButtonUp) ? 1 : 0; break;
                case 5: context.Value = _lastEventArgs.ButtonFlags.HasFlag(MouseInput.ButtonFlags.RightButtonDown) ? 1 : 0; break;
                case 6: context.Value = _lastEventArgs.ButtonFlags.HasFlag(MouseInput.ButtonFlags.RightButtonUp) ? 1 : 0; break;
                case 7: context.Value = _lastEventArgs.ButtonFlags.HasFlag(MouseInput.ButtonFlags.Wheel) ? 1 : 0; break;
                case 8: context.Value = (float)_dragX; break;
                case 9: context.Value = (float)_dragY; break;
                case 10: context.Value = _lastEventArgs.WheelDelta; break;
                case 11: context.Value = _lastEventArgs.X; break;
                case 12: context.Value = _lastEventArgs.Y; break;
                case 13: context.Value = (float)_moveX; break;
                case 14: context.Value = (float)_moveY; break;
            }
            return context;
        }

        bool _asyncChanged = false;
        MouseInput.MouseEventArgs _lastEventArgs = null;
        bool _pressed = false;
        int _dragX = 0;
        int _dragY = 0;
        
        int _moveX = 0;
        int _moveY = 0;
        
        double _clampXMin;
        double _clampXMax;
        
        double _clampYMin;
        double _clampYMax;
        
    }
}

