//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using System.Text.RegularExpressions;

namespace Framefield.Core.IDff860684_c11e_4afc_83f2_4d89345dc4f1
{
    public class Class_MatchRegext : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            String = 0,
            MatchPattern = 1
        }
        //<<< _inputids


        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var String = inputs[(int)InputId.String].Eval(context).Text;
            var MatchPattern = inputs[(int)InputId.MatchPattern].Eval(context).Text;
            //<<< _params            
            
            if (String.IsNullOrEmpty(String) || String.IsNullOrEmpty(MatchPattern) ) {
                context.Text = String.Empty;
                return context;
            }
            string result = string.Empty;
            
            var m = Regex.Match(String, MatchPattern);
            if(m.Success) {
            context.Text = m.Groups[1].Value;
            }             
            else {
                context.Text = "";
            }
            return context;
        }
    }
}

