//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDe781042f_1032_40e7_a85f_16263c355c1a
{
    public class Class_LimitColorRange : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            MinColorR = 2,
            MinColorG = 3,
            MinColorB = 4,
            MinColorA = 5,
            MaxColorR = 6,
            MaxColorG = 7,
            MaxColorB = 8,
            MaxColorA = 9
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            return PrepareAndEvalOnChange(context, () =>
            {
                //>>> __params
                var Code = inputs[(int)InputId.Code].Eval(context).Text;
                var Image = inputs[(int)InputId.Image].Eval(context).Image; 
                var MinColorR = inputs[(int)InputId.MinColorR].Eval(context).Value;
                var MinColorG = inputs[(int)InputId.MinColorG].Eval(context).Value;
                var MinColorB = inputs[(int)InputId.MinColorB].Eval(context).Value;
                var MinColorA = inputs[(int)InputId.MinColorA].Eval(context).Value;
                var MinColor = new Color4(MinColorR, MinColorG, MinColorB, MinColorA);
                var MaxColorR = inputs[(int)InputId.MaxColorR].Eval(context).Value;
                var MaxColorG = inputs[(int)InputId.MaxColorG].Eval(context).Value;
                var MaxColorB = inputs[(int)InputId.MaxColorB].Eval(context).Value;
                var MaxColorA = inputs[(int)InputId.MaxColorA].Eval(context).Value;
                var MaxColor = new Color4(MaxColorR, MaxColorG, MaxColorB, MaxColorA);
                //<<< __params

                if (Image == null)
                    return;

                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 1));

                //>>> __setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("MinColor").AsVector().Set(MinColor);
                    _effect.GetVariableByName("MaxColor").AsVector().Set(MaxColor);
                //<<< __setup

                var prevBlendState = context.BlendState;
                context.BlendState = OperatorPartContext.DefaultRenderer.DisabledBlendState;

                Render(context);

                context.BlendState = prevBlendState;

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}
