//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

using System.Runtime.InteropServices;
using Buffer = SharpDX.Direct3D11.Buffer;

namespace Framefield.Core.ID70acdfe1_122f_4cdf_9e61_6a314ebade05
{
    public class Class_TurbulenceNoise2 : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            NoiseTexture = 1,
            Time = 2,
            Steps = 3,
            ColorR = 4,
            ColorG = 5,
            ColorB = 6,
            ColorA = 7,
            SubSpeed = 8,
            SmearFactor = 9,
            ZStep = 10,
            BStep = 11,
            OffsetX = 12,
            OffsetY = 13,
            Wobble = 14
        }
        //<<< _inputids

        //int[] _permutationTable = new int[512];
        //int _permutaionTableSize = 512 * 4 * 4; // 512 entries * intSize * 16byte alignment padding
        //Buffer _permutationTableConstBuffer;


        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            return PrepareAndEvalOnChange(context, () =>
            {
                //>>> _params
                var Code = inputs[(int)InputId.Code].Eval(context).Text;
                var NoiseTexture = inputs[(int)InputId.NoiseTexture].Eval(context).Image; // Needs to be checked for null!
                var Time = inputs[(int)InputId.Time].Eval(context).Value;
                var Steps = inputs[(int)InputId.Steps].Eval(context).Value;
                var ColorR = inputs[(int)InputId.ColorR].Eval(context).Value;
                var ColorG = inputs[(int)InputId.ColorG].Eval(context).Value;
                var ColorB = inputs[(int)InputId.ColorB].Eval(context).Value;
                var ColorA = inputs[(int)InputId.ColorA].Eval(context).Value;
                var Color = new Color4(ColorR, ColorG, ColorB, ColorA);
                var SubSpeed = inputs[(int)InputId.SubSpeed].Eval(context).Value;
                var SmearFactor = inputs[(int)InputId.SmearFactor].Eval(context).Value;
                var ZStep = inputs[(int)InputId.ZStep].Eval(context).Value;
                var BStep = inputs[(int)InputId.BStep].Eval(context).Value;
                var OffsetX = inputs[(int)InputId.OffsetX].Eval(context).Value;
                var OffsetY = inputs[(int)InputId.OffsetY].Eval(context).Value;
                var Offset = new Vector2(OffsetX, OffsetY);
                var Wobble = inputs[(int)InputId.Wobble].Eval(context).Value;
                //<<< _params

                if(NoiseTexture == null)
                    return;
                    
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));             

                //>>> _setup
                using (var NoiseTextureView = new ShaderResourceView(context.D3DDevice, NoiseTexture))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("NoiseTexture").AsShaderResource().SetResource(NoiseTextureView);
                    _effect.GetVariableByName("Time").AsScalar().Set(Time);
                    _effect.GetVariableByName("Steps").AsScalar().Set(Steps);
                    _effect.GetVariableByName("Color").AsVector().Set(new Vector4(ColorR, ColorG, ColorB, ColorA));
                    _effect.GetVariableByName("SubSpeed").AsScalar().Set(SubSpeed);
                    _effect.GetVariableByName("SmearFactor").AsScalar().Set(SmearFactor);
                    _effect.GetVariableByName("ZStep").AsScalar().Set(ZStep);
                    _effect.GetVariableByName("BStep").AsScalar().Set(BStep);
                    _effect.GetVariableByName("Offset").AsVector().Set(new Vector2(OffsetX, OffsetY));
                    _effect.GetVariableByName("Wobble").AsScalar().Set(Wobble);
                //<<< _setup

                    Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

