//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
namespace Framefield.Core.ID568eab9a_a93d_4efa_b1da_bc17b37d9bf3
{

    public class Class_HoldDuration : OperatorPart.Function, Framefield.Core.OperatorPartTraits.ITimeAccessor
    {
        //>>> _inputids
        private enum InputId
        {
            StartValue = 0,
            ResetTrigger = 1,
            UpTrigger = 2,
            DownTrigger = 3,
            UpSpeed = 4,
            DownSpeed = 5,
            ValueRangeMin = 6,
            ValueRangeMax = 7
        }
        //<<< _inputids
        
        const float UNDEFINED_VALUE = -42;
        
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var StartValue = inputs[(int)InputId.StartValue].Eval(context).Value;
            var ResetTrigger = inputs[(int)InputId.ResetTrigger].Eval(context).Value;
            var UpTrigger = inputs[(int)InputId.UpTrigger].Eval(context).Value;
            var DownTrigger = inputs[(int)InputId.DownTrigger].Eval(context).Value;
            var UpSpeed = inputs[(int)InputId.UpSpeed].Eval(context).Value;
            var DownSpeed = inputs[(int)InputId.DownSpeed].Eval(context).Value;
            var ValueRangeMin = inputs[(int)InputId.ValueRangeMin].Eval(context).Value;
            var ValueRangeMax = inputs[(int)InputId.ValueRangeMax].Eval(context).Value;
            var ValueRange = new Vector2(ValueRangeMin, ValueRangeMax);
            //<<< _params
                       
            var dt = context.GlobalTime - _lastTime;
            _lastTime = context.GlobalTime;
            
            if( _value == UNDEFINED_VALUE) {
                _value = StartValue;
            }
            
            
            if(ResetTrigger > 0) {
                _value = StartValue;
            }
            else {
                if( UpTrigger > 0) {
                    _value += dt * UpSpeed;
                }
                else {
                    _value -= dt * DownSpeed;
                }
            }
            
            _value = Math.Min( ValueRangeMax,  Math.Max( _value, ValueRangeMin));
                        
            context.Value = _value;
            return context;
        }
        
        
        private float _lastTime;
        private float _value = UNDEFINED_VALUE;
    }
}

