//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDd1c4094a_459e_4b45_9c74_37b56ca2b795
{
    public class Class_HalftoneDots : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            DotsSize = 2,
            Contrast = 3,
            Angle = 4,
            Color0R = 5,
            Color0G = 6,
            Color0B = 7,
            Color0A = 8,
            Color1R = 9,
            Color1G = 10,
            Color1B = 11,
            Color1A = 12,
            Bright = 13
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image = inputs[(int)InputId.Image].Eval(context).Image; // Needs to be checked for null!
            var DotsSize = inputs[(int)InputId.DotsSize].Eval(context).Value;
            var Contrast = inputs[(int)InputId.Contrast].Eval(context).Value;
            var Angle = inputs[(int)InputId.Angle].Eval(context).Value;
            var Color0R = inputs[(int)InputId.Color0R].Eval(context).Value;
            var Color0G = inputs[(int)InputId.Color0G].Eval(context).Value;
            var Color0B = inputs[(int)InputId.Color0B].Eval(context).Value;
            var Color0A = inputs[(int)InputId.Color0A].Eval(context).Value;
            var Color0 = new Color4(Color0R, Color0G, Color0B, Color0A);
            var Color1R = inputs[(int)InputId.Color1R].Eval(context).Value;
            var Color1G = inputs[(int)InputId.Color1G].Eval(context).Value;
            var Color1B = inputs[(int)InputId.Color1B].Eval(context).Value;
            var Color1A = inputs[(int)InputId.Color1A].Eval(context).Value;
            var Color1 = new Color4(Color1R, Color1G, Color1B, Color1A);
            var Bright = inputs[(int)InputId.Bright].Eval(context).Value;
            //<<< _params
            
            if(Image == null)
                return context;


            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("DotsSize").AsScalar().Set(DotsSize);
                    _effect.GetVariableByName("Contrast").AsScalar().Set(Contrast);
                    _effect.GetVariableByName("Angle").AsScalar().Set(Angle);
                    _effect.GetVariableByName("Color0").AsVector().Set(new Vector4(Color0R, Color0G, Color0B, Color0A));
                    _effect.GetVariableByName("Color1").AsVector().Set(new Vector4(Color1R, Color1G, Color1B, Color1A));
                    _effect.GetVariableByName("Bright").AsScalar().Set(Bright);
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

