//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDeeefa5a3_dc82_4c33_b232_0de4aacd5512
{
    public class Class_GetCameraPosition : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            Camera = 0
        }
        //<<< _inputids
        //>>> _outputids
        private enum OutputId
        {
            x = 0,
            y = 1,
            z = 2
        }
        //<<< _outputids


        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Camera = inputs[(int)InputId.Camera].Eval(context).Dynamic;  // Needs to be checked for null!
            //<<< _params
            
            if(Camera == null)
                return context;
            
            Framefield.Core.OperatorPartTraits.ICameraProvider camProvider = Camera.This as Framefield.Core.OperatorPartTraits.ICameraProvider;
            if (camProvider == null)
            {
                Logger.Error(this, "camera not defined");
                return context;
            }

            
            var position =  camProvider.GetLastPosition();
            
            switch(outputIdx) {
                case (int)OutputId.x: 
                    context.Value = position.X;
                    break;
            
                case (int)OutputId.y: 
                    context.Value = position.Y;
                    break;
            
                case (int)OutputId.z: 
                    context.Value = position.Z;
                    break;                
            }
           
            return context;
        }
    }
}

