using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using SharpDX;
using SharpDX.Direct3D11;
using Framefield.Core.Rendering;
using Buffer = SharpDX.Direct3D11.Buffer;

namespace Framefield.Core.ID66b07e47_1541_47f5_a085_35f8dadfd6d7
{
    public class Class_FlatShaderNearestFilter : FXSourceCodeFunction, IFXSceneSourceCode, IMaterial
    {

        class Renderer : BaseRenderer
        {
        }

        public override void Dispose() {
            Utilities.DisposeObj(ref _renderer);
            base.Dispose();
        }

        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Scene = 1,
            ColorMulR = 2,
            ColorMulG = 3,
            ColorMulB = 4,
            ColorMulA = 5,
            OverrideAlpha = 6
        }
        //<<< _inputids
        bool _firstEval = true;
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Scene = inputs[(int)InputId.Scene];
            var ColorMulR = inputs[(int)InputId.ColorMulR].Eval(context).Value;
            var ColorMulG = inputs[(int)InputId.ColorMulG].Eval(context).Value;
            var ColorMulB = inputs[(int)InputId.ColorMulB].Eval(context).Value;
            var ColorMulA = inputs[(int)InputId.ColorMulA].Eval(context).Value;
            var ColorMul = new Color4(ColorMulR, ColorMulG, ColorMulB, ColorMulA);
            var OverrideAlpha = (int) inputs[(int)InputId.OverrideAlpha].Eval(context).Value;
            //<<< _params
        
            if (_firstEval) {
                for (int i = 0; i < NumCodes(); ++i)
                    Compile(i);
                _firstEval = false;
                Changed = true;
            }

            var prevEffect = context.Effect;
            var prevRenderer = context.Renderer;
            context.Effect = _effect;
            context.Renderer = _renderer;

            var prevMaterial = (IMaterial) context.Objects[OperatorPartContext.MATERIAL_ID];
            context.Objects[OperatorPartContext.MATERIAL_ID] = this;
            if (OverrideAlpha > 0.5f) 
            {
                ColorMulA *= prevMaterial.Diffuse.Alpha;
                ColorMul.Alpha = ColorMulA;
            }
            Diffuse = ColorMul;

            _effect.GetVariableByName("ColorMul").AsVector().Set(new Vector4(ColorMulR, ColorMulG, ColorMulB,ColorMulA)); 

            Scene.Eval(context);
            context.Objects[OperatorPartContext.MATERIAL_ID] = prevMaterial;
            context.Effect = prevEffect;
            context.Renderer = prevRenderer;

            return context;
        }

        private Renderer _renderer = new Renderer();

        public Color4 Ambient { get; private set; }
        public Color4 Diffuse { get; private set; }
        public Color4 Specular { get; private set; }
        public Color4 Emission { get; private set; }
        public float Shininess { get; private set; }
    }
}


