//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using Framefield.Core.Rendering;

namespace Framefield.Core.ID7a1237f5_79d6_4545_9ec5_1ac0a750194d
{
    public class Class_FallOffShader : FXSourceCodeFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Scene = 1,
            RangeX = 2,
            RangeY = 3,
            FallOff = 4,
            FrontColorR = 5,
            FrontColorG = 6,
            FrontColorB = 7,
            FrontColorA = 8,
            EdgeColorR = 9,
            EdgeColorG = 10,
            EdgeColorB = 11,
            EdgeColorA = 12,
            BackColorR = 13,
            BackColorG = 14,
            BackColorB = 15,
            BackColorA = 16
        }
        //<<< _inputids
        #region Renderer
        public class Renderer : BaseRenderer
        {
            public override void SetupEffect(OperatorPartContext context)
            {
                base.SetupEffect(context);
                try
                {
                    SetupMaterialConstBuffer(context);
                    SetupFogSettingsConstBuffer(context);
                    SetupPointLightsConstBuffer(context);
                }
                catch (Exception e)
                {
                    Logger.Error(ParentFunc,"Error building constant buffer: {0} - Source: {1}", e.Message, e.Source);
                }
            }
            public OperatorPart.Function ParentFunc{get;set;}
        }
        #endregion

        public Class_FallOffShader()
        {
            _renderer = new Renderer(){ParentFunc=this};
        }

        public override void Dispose()
        {
            Utilities.DisposeObj(ref _renderer);
            base.Dispose();
        }

        bool _firstEval = true;
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            // >>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Scene = inputs[(int)InputId.Scene];
            var RangeX = inputs[(int)InputId.RangeX].Eval(context).Value;
            var RangeY = inputs[(int)InputId.RangeY].Eval(context).Value;
            var Range = new Vector2(RangeX, RangeY);
            var FallOff = inputs[(int)InputId.FallOff].Eval(context).Value;
            var FrontColorR = inputs[(int)InputId.FrontColorR].Eval(context).Value;
            var FrontColorG = inputs[(int)InputId.FrontColorG].Eval(context).Value;
            var FrontColorB = inputs[(int)InputId.FrontColorB].Eval(context).Value;
            var FrontColorA = inputs[(int)InputId.FrontColorA].Eval(context).Value;
            var FrontColor = new Color4(FrontColorR, FrontColorG, FrontColorB, FrontColorA);
            var EdgeColorR = inputs[(int)InputId.EdgeColorR].Eval(context).Value;
            var EdgeColorG = inputs[(int)InputId.EdgeColorG].Eval(context).Value;
            var EdgeColorB = inputs[(int)InputId.EdgeColorB].Eval(context).Value;
            var EdgeColorA = inputs[(int)InputId.EdgeColorA].Eval(context).Value;
            var EdgeColor = new Color4(EdgeColorR, EdgeColorG, EdgeColorB, EdgeColorA);
            var BackColorR = inputs[(int)InputId.BackColorR].Eval(context).Value;
            var BackColorG = inputs[(int)InputId.BackColorG].Eval(context).Value;
            var BackColorB = inputs[(int)InputId.BackColorB].Eval(context).Value;
            var BackColorA = inputs[(int)InputId.BackColorA].Eval(context).Value;
            var BackColor = new Color4(BackColorR, BackColorG, BackColorB, BackColorA);
            // <<< _params

            if (_firstEval)
            {
                for (int i = 0; i < NumCodes(); ++i)
                    Compile(i);
                _firstEval = false;
                Changed = true;
            }

            using (new PropertyStasher<OperatorPartContext>(context, "Effect", "Renderer"))
            {
                _effect.GetVariableByName("Range").AsVector().Set(new Vector2(RangeX, RangeY));
                _effect.GetVariableByName("FallOff").AsScalar().Set(FallOff);
                _effect.GetVariableByName("FrontColor").AsVector().Set(new Vector4(FrontColorR, FrontColorG, FrontColorB, FrontColorA));
                _effect.GetVariableByName("BackColor").AsVector().Set(new Vector4(BackColorR, BackColorG, BackColorB, BackColorA));
                _effect.GetVariableByName("EdgeColor").AsVector().Set(new Vector4(EdgeColorR, EdgeColorG, EdgeColorB, EdgeColorA));
                context.Effect = _effect;
                context.Renderer = _renderer;
                Scene.Eval(context);
            }

            /*
            //>>> _setup
            {
                _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                _effect.GetVariableByName("Range").AsVector().Set(new Vector2(RangeX, RangeY));
                _effect.GetVariableByName("FallOff").AsScalar().Set(FallOff);
                _effect.GetVariableByName("FrontColor").AsVector().Set(new Vector4(FrontColorR, FrontColorG, FrontColorB, FrontColorA));
                _effect.GetVariableByName("EdgeColor").AsVector().Set(new Vector4(EdgeColorR, EdgeColorG, EdgeColorB, EdgeColorA));
                _effect.GetVariableByName("BackColor").AsVector().Set(new Vector4(BackColorR, BackColorG, BackColorB, BackColorA));
            //<<< _setup            
            */
            return context;
        }

        Renderer _renderer;
    }
}


