//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDf45e4748_aaa5_40e2_8192_c9ada6f06d5e
{
    public class Class_EquallyTriggered : OperatorPart.Function, Framefield.Core.OperatorPartTraits.ITimeAccessor
    {
        //>>> _inputids
        private enum InputId
        {
            InputATrigger = 0,
            InputBTrigger = 1,
            TimeEpsilon = 2
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var InputATrigger = inputs[(int)InputId.InputATrigger].Eval(context).Value;
            var InputBTrigger = inputs[(int)InputId.InputBTrigger].Eval(context).Value;
            var TimeEpsilon = inputs[(int)InputId.TimeEpsilon].Eval(context).Value;
            //<<< _params

            if (context.Time < _tiggerInputATime || context.Time < _tiggerInputBTime)
            {
                _oldInputATrigger = 1;
                _tiggerInputATime = context.Time;
                _tiggerInputATimeValid = false;
                _oldInputBTrigger = 1;
                _tiggerInputBTime = context.Time;
                _tiggerInputBTimeValid = false;
                //Logger.Info(this, "reset");
            }

            bool inputATriggerUp = _oldInputATrigger < 0.5f && InputATrigger > 0.5f;
            bool inputATriggerDown = _oldInputATrigger > 0.5f && InputATrigger < 0.5f;
            _oldInputATrigger = InputATrigger;
            bool inputBTriggerUp = _oldInputBTrigger < 0.5f && InputBTrigger > 0.5f;
            bool inputBTriggerDown = _oldInputBTrigger > 0.5f && InputBTrigger < 0.5f;
            _oldInputBTrigger = InputBTrigger;
            if (inputATriggerUp)
            {
                _tiggerInputATime = context.Time;
                _tiggerInputATimeValid = true;
                //Logger.Info(this, "up a");
            }
            if (inputATriggerDown)
            {
                _tiggerInputATimeValid = false;
                //Logger.Info(this, "down a");
            }
            if (inputBTriggerUp)
            {
                _tiggerInputBTime = context.Time;
                _tiggerInputBTimeValid = true;
                //Logger.Info(this, "up b");
            }
            if (inputBTriggerDown)
            {
                _tiggerInputBTimeValid = false;
                //Logger.Info(this, "down b");
            }
            
            float val = (_tiggerInputATimeValid && _tiggerInputBTimeValid && 
                         Math.Abs(_tiggerInputATime - _tiggerInputBTime) < TimeEpsilon/* &&
                         Math.Abs(_tiggerInputATime - context.Time) < TimeEpsilon &&
                         Math.Abs(_tiggerInputBTime - context.Time) < TimeEpsilon*/) ? 1.0f : 0.0f;
            context.Value = val;
            return context;
        }

        float _oldInputATrigger;
        float _tiggerInputATime = 0;
        bool _tiggerInputATimeValid = false;
        float _oldInputBTrigger;
        float _tiggerInputBTime = 0;
        bool _tiggerInputBTimeValid = false;
    }
}

