//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using SharpDX.Direct3D;
using SharpDX.DXGI;

namespace Framefield.Core.IDa56bb365_8d12_4000_9a55_8e545c7f94a1
{
    public class Class_DepthToColorLinear : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            Camera = 2
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image = inputs[(int)InputId.Image].Eval(context).DepthImage; // Needs to be checked for null!
            var Camera = inputs[(int)InputId.Camera].Eval(context).Dynamic;  // Needs to be checked for null!
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 1));

                var camProvider = Camera.This as Framefield.Core.OperatorPartTraits.ICameraProvider;
                if (camProvider == null)
                {
                    Logger.Error(this, "camera not defined");
                    return;
                }

                var shaderDesc = new ShaderResourceViewDescription();
                shaderDesc.Format = Format.R32_Float;
                shaderDesc.Dimension = ShaderResourceViewDimension.Texture2D;
                shaderDesc.Texture2D.MipLevels = 1;
                using (var depthTexture = new ShaderResourceView(context.D3DDevice, Image, shaderDesc))
                {
                    _effect.GetVariableByName("txDepth").AsShaderResource().SetResource(depthTexture); 

                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Range").AsVector().Set(camProvider.GetLastNearFarClip());
                    Logger.Info(this, "nearFar: {0}", camProvider.GetLastNearFarClip());
                    Render(context);
                }
            });
        }

    }
}

