//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using SharpDX.Direct3D;
using SharpDX.DXGI;

namespace Framefield.Core.IDd44d9bdd_09a4_4c73_8ad2_9a8e37fb4933
{
    public class Class_DepthToColor : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            RangeMin = 2,
            RangeMax = 3
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image = inputs[(int)InputId.Image].Eval(context).Image; // Needs to be checked for null!
            var RangeMin = inputs[(int)InputId.RangeMin].Eval(context).Value;
            var RangeMax = inputs[(int)InputId.RangeMax].Eval(context).Value;
            var Range = new Vector2(RangeMin, RangeMax);
            //<<< _params

            if (context.DepthImage == null)
                return context;

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 1));

                var shaderDesc = new ShaderResourceViewDescription();
                shaderDesc.Format = Format.R32_Float;
                shaderDesc.Dimension = ShaderResourceViewDimension.Texture2D;
                shaderDesc.Texture2D.MipLevels = 1;
                using (var depthTexture = new ShaderResourceView(context.D3DDevice, context.DepthImage, shaderDesc)) {
                    _effect.GetVariableByName("txDepth").AsShaderResource().SetResource(depthTexture); 

                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("Range").AsVector().Set(new Vector2(RangeMin, RangeMax));
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
                }
            });
        }

    }
}

