//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using System.IO;
using SharpDX.DXGI;

namespace Framefield.Core.ID185b06cd_15c6_4ff3_b69c_eca395b14ad5
{
    public class Class_CubeMapFromCross : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            Image = 0
        }
        //<<< _inputids


        public override void Dispose()
        {
            Utilities.DisposeObj(ref _textureCube);
        }

        private bool BuildTextureArray(OperatorPartContext context, Texture2D origImage)
        {
            float aspectRatio = origImage.Description.Width/(float)origImage.Description.Height;
            int texWidth = origImage.Description.Width/(aspectRatio > 1.0f ? 4 : 3);
            int texHeight = origImage.Description.Height/(aspectRatio > 1.0f ? 3 : 4);
            int mipLevels = 1;

            var uavVisuDesc = new Texture2DDescription
                                    {
                                        BindFlags = BindFlags.ShaderResource,
                                        Format = origImage.Description.Format,
                                        Width = texWidth,
                                        Height = texHeight,
                                        MipLevels = mipLevels,
                                        SampleDescription = new SampleDescription(1, 0),
                                        Usage = ResourceUsage.Default,
                                        OptionFlags = ResourceOptionFlags.TextureCube,
                                        CpuAccessFlags = CpuAccessFlags.None,
                                        ArraySize = 6
                                    };
                                
            Utilities.DisposeObj(ref _textureCube);
            _textureCube = new Texture2D(D3DDevice.Device, uavVisuDesc);
            
            int[,] mapPositions = { {2,1},{0,1},{1,0},{1,2},{1,1},{3,1} };  // Right Left  top   Bot  front Back
            if (aspectRatio < 1)
            {
                Logger.Info("bla");
                mapPositions[5,0] = 1;
                mapPositions[5,1] = 3;
            }
            var dxContext = context.D3DDevice.ImmediateContext;
            for (int arraySlice = 0; arraySlice < 6; ++arraySlice)
            {
                ResourceRegion region = new ResourceRegion(mapPositions[arraySlice,0]*texWidth,
                                                           mapPositions[arraySlice,1]*texHeight,
                                                           0,
                                                           mapPositions[arraySlice,0]*texWidth+texWidth,
                                                           mapPositions[arraySlice,1]*texHeight+texHeight,
                                                           1);

                for (int mipSlice = 0; mipSlice < mipLevels; ++mipSlice)
                {
                    int mipSize;
                    int idx = _textureCube.CalculateSubResourceIndex(mipSlice, arraySlice, out mipSize);
                    dxContext.CopySubresourceRegion(origImage, mipSlice, region, _textureCube, idx);
                }
            }

            return true;
        }
        
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            //>>> _params
            var Image = inputs[(int)InputId.Image].Eval(context).Image; // Needs to be checked for null!
            //<<< _params

if (Image == null)
    return context;

            if (Changed)
            {
                Dispose();
                BuildTextureArray(context, Image);
                Changed = false;
            }

            if (_textureCube != null)
                context.Image = _textureCube;

            return context;
        }

        private Texture2D _textureCube;
        private Texture2D[] _lastImages = new Texture2D[6];
    }
}

