//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID158f3634_7f87_49ff_85da_bd0ea5f3f077
{
    public class Class_ContextVariables : OperatorPart.Function, Framefield.Core.OperatorPartTraits.ITimeAccessor
    {
        //>>> _inputids
        private enum InputId
        {
            Value = 0
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> params
            float v = (float) inputs[(int)InputId.Value].Eval(context).Value;
            //<<< params            
            
            string buffer = "context.Variables:\n";
            foreach (var e in context.Variables)
            {
                buffer += String.Format("  {0}: {1}\n", e.Key, e.Value);
            }

            context.Text = buffer;
            return context;
        }
    }
}

