//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID010ffa00_0637_4a4c_8825_608b27d5d94e
{
    public class Class_CirclesXorPattern : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            CenterX = 1,
            CenterY = 2,
            circleSize = 3,
            numCircles = 4,
            Angle = 5,
            Zoom = 6,
            PalletteShift = 7
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var CenterX = inputs[(int)InputId.CenterX].Eval(context).Value;
            var CenterY = inputs[(int)InputId.CenterY].Eval(context).Value;
            var Center = new Vector2(CenterX, CenterY);
            var circleSize = inputs[(int)InputId.circleSize].Eval(context).Value;
            var numCircles = inputs[(int)InputId.numCircles].Eval(context).Value;
            var Angle = inputs[(int)InputId.Angle].Eval(context).Value;
            var Zoom = inputs[(int)InputId.Zoom].Eval(context).Value;
            var PalletteShift = inputs[(int)InputId.PalletteShift].Eval(context).Value;
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Center").AsVector().Set(new Vector2(CenterX, CenterY));
                    _effect.GetVariableByName("circleSize").AsScalar().Set(circleSize);
                    _effect.GetVariableByName("numCircles").AsScalar().Set(numCircles);
                    _effect.GetVariableByName("Angle").AsScalar().Set(Angle);
                    _effect.GetVariableByName("Zoom").AsScalar().Set(Zoom);
                    _effect.GetVariableByName("PalletteShift").AsScalar().Set(PalletteShift);
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}



