//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID8be6ff88_67fd_49bc_95ae_812e81043d92
{
    public class Class_Circles : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            ColorAR = 1,
            ColorAG = 2,
            ColorAB = 3,
            ColorAA = 4,
            ColorBR = 5,
            ColorBG = 6,
            ColorBB = 7,
            ColorBA = 8,
            CenterX = 9,
            CenterY = 10,
            ShiftX = 11,
            ShiftY = 12,
            Offset = 13,
            TileFreq = 14,
            Thick = 15
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var ColorAR = inputs[(int)InputId.ColorAR].Eval(context).Value;
            var ColorAG = inputs[(int)InputId.ColorAG].Eval(context).Value;
            var ColorAB = inputs[(int)InputId.ColorAB].Eval(context).Value;
            var ColorAA = inputs[(int)InputId.ColorAA].Eval(context).Value;
            var ColorA = new Color4(ColorAR, ColorAG, ColorAB, ColorAA);
            var ColorBR = inputs[(int)InputId.ColorBR].Eval(context).Value;
            var ColorBG = inputs[(int)InputId.ColorBG].Eval(context).Value;
            var ColorBB = inputs[(int)InputId.ColorBB].Eval(context).Value;
            var ColorBA = inputs[(int)InputId.ColorBA].Eval(context).Value;
            var ColorB = new Color4(ColorBR, ColorBG, ColorBB, ColorBA);
            var CenterX = inputs[(int)InputId.CenterX].Eval(context).Value;
            var CenterY = inputs[(int)InputId.CenterY].Eval(context).Value;
            var Center = new Vector2(CenterX, CenterY);
            var ShiftX = inputs[(int)InputId.ShiftX].Eval(context).Value;
            var ShiftY = inputs[(int)InputId.ShiftY].Eval(context).Value;
            var Shift = new Vector2(ShiftX, ShiftY);
            var Offset = inputs[(int)InputId.Offset].Eval(context).Value;
            var TileFreq = inputs[(int)InputId.TileFreq].Eval(context).Value;
            var Thick = inputs[(int)InputId.Thick].Eval(context).Value;
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("ColorA").AsVector().Set(new Vector4(ColorAR, ColorAG, ColorAB, ColorAA));
                    _effect.GetVariableByName("ColorB").AsVector().Set(new Vector4(ColorBR, ColorBG, ColorBB, ColorBA));
                    _effect.GetVariableByName("Center").AsVector().Set(new Vector2(CenterX, CenterY));
                    _effect.GetVariableByName("Shift").AsVector().Set(new Vector2(ShiftX, ShiftY));
                    _effect.GetVariableByName("Offset").AsScalar().Set(Offset);
                    _effect.GetVariableByName("TileFreq").AsScalar().Set(TileFreq);
                    _effect.GetVariableByName("Thick").AsScalar().Set(Thick);
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}



