//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID0df41707_8154_41f8_a646_4e90ab8bc784
{
    public class Class_CheckerBoard2 : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            ColorAR = 1,
            ColorAG = 2,
            ColorAB = 3,
            ColorAA = 4,
            ColorBR = 5,
            ColorBG = 6,
            ColorBB = 7,
            ColorBA = 8,
            BlockSizeX = 9,
            BlockSizeY = 10
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var ColorAR = inputs[(int)InputId.ColorAR].Eval(context).Value;
            var ColorAG = inputs[(int)InputId.ColorAG].Eval(context).Value;
            var ColorAB = inputs[(int)InputId.ColorAB].Eval(context).Value;
            var ColorAA = inputs[(int)InputId.ColorAA].Eval(context).Value;
            var ColorA = new Color4(ColorAR, ColorAG, ColorAB, ColorAA);
            var ColorBR = inputs[(int)InputId.ColorBR].Eval(context).Value;
            var ColorBG = inputs[(int)InputId.ColorBG].Eval(context).Value;
            var ColorBB = inputs[(int)InputId.ColorBB].Eval(context).Value;
            var ColorBA = inputs[(int)InputId.ColorBA].Eval(context).Value;
            var ColorB = new Color4(ColorBR, ColorBG, ColorBB, ColorBA);
            var BlockSizeX = inputs[(int)InputId.BlockSizeX].Eval(context).Value;
            var BlockSizeY = inputs[(int)InputId.BlockSizeY].Eval(context).Value;
            var BlockSize = new Vector2(BlockSizeX, BlockSizeY);
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("ColorA").AsVector().Set(new Vector4(ColorAR, ColorAG, ColorAB, ColorAA));
                    _effect.GetVariableByName("ColorB").AsVector().Set(new Vector4(ColorBR, ColorBG, ColorBB, ColorBA));
                    _effect.GetVariableByName("BlockSize").AsVector().Set(new Vector2(BlockSizeX, BlockSizeY));
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}



