//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID13fb3188_e438_47aa_a144_316a080f6bff
{
    public class Class_ChangeDepth : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            Image = 0,
            Depth = 1
        }
        //<<< _inputids

        public override void Dispose()
        {
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            //>>> __params
            var ImageInput = inputs[(int)InputId.Image];
            var DepthInput = inputs[(int)InputId.Depth];
            //<<< __params

            var image = ImageInput.Eval(context).Image;
            var depth = DepthInput.Eval(context).DepthImage;
            if (image == null || depth == null)
            {
                context.Image = null;
                context.DepthImage = null;
                return context;
            }

            context.Image = image;
            context.DepthImage = depth;

            return context;
        }

    }
}

